<?php

declare(strict_types=1);

namespace NoahVet\Reef\Iterator\Factory;

use NoahVet\Reef\Factory\Jane\EndpointFactoryInterface;
use NoahVet\Reef\Iterator\ApiClientChunkedReefIteratorDecorator;
use NoahVet\Reef\Iterator\ApiClientSimpleReefIterator;
use NoahVet\Reef\Iterator\ReefApiIteratorInterface;
use NoahVet\Reef\Jane\Normalizer\JaneObjectNormalizer;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class ReefApiIteratorFactory implements ReefApiIteratorFactoryInterface
{
    public function __construct(
        private int $chunkSize,
        private readonly EndpointFactoryInterface $endpointFactory,
    ) {
    }

    /**
     * @template TEndpoint of object
     * @template TValue of object
     *
     * @param class-string<TEndpoint> $endpoint
     * @param class-string<TValue>    $responseClass
     * @param array<string, mixed>    $params
     *
     * @return ReefApiIteratorInterface<TValue, array<string, mixed>>
     */
    public function create(
        object $client,
        string $endpoint,
        string $responseClass,
        array $params = [],
        int $querySize = 50,
        ?string $chunkProperty = null,
        NormalizerInterface $responseNormalizer = new JaneObjectNormalizer(),
    ): ReefApiIteratorInterface {
        /** @var ReefApiIteratorInterface<TValue, array<string, mixed>> $ret */
        $ret = new ApiClientSimpleReefIterator(
            $client,
            $endpoint,
            $this->endpointFactory,
            $params,
            $querySize,
            $responseNormalizer,
        );

        if (null !== $chunkProperty) {
            $ret = new ApiClientChunkedReefIteratorDecorator($ret, $chunkProperty, $this->chunkSize);
        }

        return $ret;
    }
}
