<?php

declare(strict_types=1);

namespace NoahVet\Reef\Factory\RequestContext;

use Symfony\Component\HttpFoundation\Request;

class KeywordApplier extends AbstractApplier implements KeywordApplierInterface
{
    public function apply(Request $request, array $whitelist): string
    {
        if (!isset($whitelist['keywords'])) {
            return '';
        }

        return \trim(\json_decode($request->getContent(), true)['keywords'] ?? '');
    }
}
