<?php

declare(strict_types=1);

namespace NoahVet\Reef\Event;

use Symfony\Component\HttpFoundation\Request;

class RequestAuditEvent extends AbstractAuditEvent implements AuditEventInterface
{
    public const NAME = 'reef.audit.request';

    /**
     * @param array<string, string> $extraData
     */
    public function __construct(
        protected string $action,
        protected string $resourceId,
        protected string $resourceType,
        protected string $message,
        protected array $extraData = [],
    ) {
    }

    public function getAuthenticationType(): string
    {
        return 'user_authentication';
    }

    public function getEventType(): string
    {
        return self::NAME;
    }

    public function addHttpRequestExtraData(Request $request): self
    {
        $this->extraData['httpUri'] = $request->getRequestUri();
        $this->extraData['httpMethod'] = $request->getMethod();

        return $this;
    }
}
