<?php

declare(strict_types=1);

namespace NoahVet\Reef\Event;

class CommandAuditEvent extends AbstractAuditEvent implements AuditEventInterface
{
    public const NAME = 'reef.audit.command';

    /**
     * @param array<string, string> $extraData
     */
    public function __construct(
        protected string $action,
        protected string $resourceId,
        protected string $resourceType,
        protected string $message,
        protected array $extraData = [],
    ) {
    }

    public function getAuthenticationType(): string
    {
        return 'service_authentication';
    }

    public function getEventType(): string
    {
        return self::NAME;
    }
}
