<?php

declare(strict_types=1);

namespace NoahVet\Reef\Event;

use Symfony\Contracts\EventDispatcher\Event;

abstract class AbstractAuditEvent extends Event implements AuditEventInterface
{
    protected string $action;

    protected string $message;

    protected string $resourceId;

    protected string $resourceType;

    /**
     * @var array<string, string>
     */
    protected array $extraData = [];

    abstract public function getAuthenticationType(): string;

    abstract public function getEventType(): string;

    public function getAction(): string
    {
        return $this->action;
    }

    public function getMessage(): string
    {
        return $this->message;
    }

    /**
     * @return array<string, string>
     */
    public function getExtraData(): array
    {
        return $this->extraData;
    }

    public function getResourceId(): string
    {
        return $this->resourceId;
    }

    public function getResourceType(): string
    {
        return $this->resourceType;
    }
}
