<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Tool;

interface VatToolInterface extends ToolInterface
{
    /**
     * E.g.
     *
     * Before
     *
     * 820000 (8200 €) | 2000 percent
     *
     * After
     *
     * 984000 (9840 €, 1640€ added)
     */
    public static function addVat(int $amountWithoutVat, int $vatAmount): int;

    /**
     * E.g.
     *
     * Before
     *
     * 1000 (10 €(HT)) | 1200 (12 €(TTC))
     *
     * After
     *
     * Get 2000 - 20% Vat
     */
    public static function getVat(int $amountWithVat, int $amountWithoutVat): int;

    /**
     * E.g.
     *
     * Before
     *
     * 984000 (9840 €) | 2000 percent
     *
     * After
     *
     * 820000 (8200 €, 1640€ removed)
     */
    public static function removeVat(int $amountWithVat, int $vatAmount): int;
}
