<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Tool;

class VatTool implements VatToolInterface
{
    protected static int $calculBase = 10000;

    public static function addVat(int $amountWithoutVat, int $vatAmount): int
    {
        return (int) ((float) $amountWithoutVat * (1.0 + (float) $vatAmount / (float) self::$calculBase));
    }

    public static function getVat(int $amountWithVat, int $amountWithoutVat): int
    {
        if (0 >= $amountWithoutVat) {
            throw new \InvalidArgumentException(
                'The `$amountWithoutVat` should be greater than 0.',
            );
        }
        if ($amountWithVat < $amountWithoutVat) {
            throw new \InvalidArgumentException(
                'The `$amountWithVat` should be lower than or equals to `$amountWithVat`.',
            );
        }

        return (int) (\round(((float) $amountWithVat / (float) $amountWithoutVat) - 1.0, 4) * (float) self::$calculBase);
    }

    public static function removeVat(int $amountWithVat, int $vatAmount): int
    {
        return (int) ((float) $amountWithVat / (1.0 + (float) $vatAmount / (float) self::$calculBase));
    }
}
