<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Log;

interface SyslogMessageInterface
{
    public function getAction(): ?string;

    public function setAction(string $action): self;

    public function getEventType(): ?string;

    public function setEventType(string $eventType): self;

    public function getMessage(): ?string;

    public function setMessage(string $message): self;

    public function getPrincipalId(): ?string;

    public function setPrincipalId(string $principalId): self;

    public function getResourceId(): ?string;

    public function setResourceId(string $resourceId): self;

    public function getResourceType(): ?string;

    public function setResourceType(string $resourceType): self;

    public function getVersion(): ?string;

    public function setVersion(string $version): self;

    /**
     * @return array<string, string>
     */
    public function getExtraData(): array;

    /**
     * @param array<string, string> $extraData
     *
     * @return $this
     */
    public function setExtraData(array $extraData): self;
}
