<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Log;

class SyslogMessage implements SyslogMessageInterface
{
    /**
     * Represents what we're trying to do.
     * For example :
     *      http post for a resource creation,
     *      http put for a resource update,
     *      http post for a search.
     */
    private ?string $action = null;

    private ?string $eventType = null;

    private ?string $message = null;

    private ?string $principalId = null;

    private ?string $resourceId = null;

    private ?string $resourceType = null;

    private ?string $version = null;

    /**
     * @var array<string, string>
     */
    private array $extraData = [];

    public function getAction(): ?string
    {
        return $this->action;
    }

    public function setAction(string $action): self
    {
        $this->action = $action;

        return $this;
    }

    public function getEventType(): ?string
    {
        return $this->eventType;
    }

    public function setEventType(string $eventType): self
    {
        $this->eventType = $eventType;

        return $this;
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function setMessage(string $message): self
    {
        $this->message = $message;

        return $this;
    }

    public function getPrincipalId(): ?string
    {
        return $this->principalId;
    }

    public function setPrincipalId(string $principalId): self
    {
        $this->principalId = $principalId;

        return $this;
    }

    public function getResourceId(): ?string
    {
        return $this->resourceId;
    }

    public function setResourceId(?string $resourceId): self
    {
        $this->resourceId = $resourceId;

        return $this;
    }

    public function getResourceType(): ?string
    {
        return $this->resourceType;
    }

    public function setResourceType(string $resourceType): self
    {
        $this->resourceType = $resourceType;

        return $this;
    }

    public function getVersion(): ?string
    {
        return $this->version;
    }

    public function setVersion(string $version): self
    {
        $this->version = $version;

        return $this;
    }

    /**
     * @return array<string, string>
     */
    public function getExtraData(): array
    {
        return $this->extraData;
    }

    /**
     * @param array<string, string> $extraData
     *
     * @return $this
     */
    public function setExtraData(array $extraData): self
    {
        $this->extraData = $extraData;

        return $this;
    }
}
