<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Invoice\Enum;

use NoahVet\Reef\Domain\Common\EnumTrait;
use NoahVet\Reef\Domain\Common\StringEnumInterface;

enum InvoicePaymentMethodEnum: string implements InvoicePaymentMethodEnumInterface, StringEnumInterface
{
    use EnumTrait;

    case BANK_TRANSFER = 'BANK_TRANSFER';
    case CHEQUE = 'CHEQUE';
    case CREDIT_CARD = 'CREDIT_CARD';
    case NONE = 'NONE';
    case SPECIFIC_BILLING_ACCOUNT = 'SPECIFIC_BILLING_ACCOUNT';
    case VETERINARY_ESTABLISHMENT_BILLING_ACCOUNT = 'VETERINARY_ESTABLISHMENT_BILLING_ACCOUNT';
    case VETERINARY_GROUP_BILLING_ACCOUNT = 'VETERINARY_GROUP_BILLING_ACCOUNT';

    public function isDirectDebit(): bool
    {
        return match ($this) {
            self::SPECIFIC_BILLING_ACCOUNT,
            self::VETERINARY_ESTABLISHMENT_BILLING_ACCOUNT,
            self::VETERINARY_GROUP_BILLING_ACCOUNT => true,
            default => false,
        };
    }
}
