<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Invoice\Enum;

use NoahVet\Reef\Domain\Common\EnumTrait;
use NoahVet\Reef\Domain\Common\StringEnumInterface;

enum CreditNoteLineCategoryEnum: string implements StringEnumInterface
{
    use EnumTrait;

    // FR : Acompte
    case DEPOSIT = 'DEPOSIT';

    // FR : Escompte
    case EARLY_PAYMENT_DISCOUNT = 'EARLY_PAYMENT_DISCOUNT';

    // FR : Remise de produit
    case PRODUCT_DISCOUNT = 'PRODUCT_DISCOUNT';

    // FR : Vente de produit
    case PRODUCT_SALES = 'PRODUCT_SALES';

    // FR : Remise sur prestation
    case SERVICE_DELIVERY_DISCOUNT = 'SERVICE_DELIVERY_DISCOUNT';

    // FR : Vente de prestation
    case SERVICE_DELIVERY_SALES = 'SERVICE_DELIVERY_SALES';

    // FR : Remise de service
    case SERVICE_DISCOUNT = 'SERVICE_DISCOUNT';

    // FR : Vente de service
    case SERVICE_SALES = 'SERVICE_SALES';
}
