<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Enumerator;

use NoahVet\Reef\Business\Model\Factory\ManufacturerWithTeamFactory;
use NoahVet\Reef\Business\Model\ManufacturerWithTeam;

class ManufacturerWithTeamEnumerator
{
    public function __construct(
        protected ManufacturerEnumerator $manufacturerEnumerator,
        protected ManufacturerWithTeamFactory $manufacturerWithTeamFactory,
    ) {
    }

    /**
     * @return \Generator<ManufacturerWithTeam>
     */
    public function enumerateAll(int $querySize = 50): \Generator
    {
        $manufacturers = [];

        foreach ($this->manufacturerEnumerator->enumerateAll([], $querySize) as $manufacturer) {
            $manufacturers[] = $manufacturer;

            if (\count($manufacturers) === $querySize) {
                foreach ($this->manufacturerWithTeamFactory->createBatch($manufacturers) as $item) {
                    yield $item;
                }
                $manufacturers = [];
            }
        }

        if (!empty($manufacturers)) {
            foreach ($this->manufacturerWithTeamFactory->createBatch($manufacturers) as $item) {
                yield $item;
            }
        }
    }
}
