<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\Tool;

use NoahVet\Reef\Domain\Tool\VatTool;
use NoahVet\Reef\Domain\Tool\VatToolInterface;
use PHPUnit\Framework\TestCase;

final class VatToolTest extends TestCase
{
    private VatToolInterface $subject;

    protected function setUp(): void
    {
        $this->subject = new VatTool();
    }

    public function testAddVat(): void
    {
        // Add 20% vat on 100€
        $this->assertEquals(
            12000,
            $this->subject->addVat(10000, 2000),
        );
    }

    public function testRemoveVat(): void
    {
        // Remove 20% vat on 120€
        $this->assertEquals(
            10000,
            $this->subject->removeVat(12000, 2000),
        );
    }
}
