<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\Tool;

use NoahVet\Reef\Domain\Tool\StringTool;
use PHPUnit\Framework\TestCase;

final class StringToolTest extends TestCase
{
    private StringTool $subject;

    protected function setUp(): void
    {
        $this->subject = new StringTool();
    }

    public function testFromBurgerCaseToSnakeCase(): void
    {
        self::assertEquals(
            'once_unpon_a_time',
            $this->subject::fromBurgerCaseToSnakeCase('once-unpon-a-time'),
        );
    }

    public function testFromBurgerCaseToSnakeCaseAlreadyInSnakeCase(): void
    {
        self::assertEquals(
            'once_unpon_a_time',
            $this->subject::fromBurgerCaseToSnakeCase('once_unpon_a_time'),
        );
    }

    public function testFromSpacedToPascalCase(): void
    {
        self::assertEquals(
            'Once Unpon A Time',
            $this->subject::fromSpacedToPascalCase('once unpon a time'),
        );
    }

    public function testFromSpacedToPascalCaseAlreadyInPascalCase(): void
    {
        self::assertEquals(
            'Once Unpon A Time',
            $this->subject::fromSpacedToPascalCase('Once Unpon A Time'),
        );
    }

    public function testFromPascalCaseToCamelCase(): void
    {
        self::assertEquals(
            'inPascalCase',
            $this->subject::fromPascalCaseToCamelCase('InPascalCase'),
        );
    }

    public function testFromPascalCaseToCamelCaseAlreadyInCamelCase(): void
    {
        self::assertEquals(
            'alreadyInCamelCase',
            $this->subject::fromPascalCaseToCamelCase('alreadyInCamelCase'),
        );
    }
}
