<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\Tool;

use NoahVet\Reef\Domain\Tool\FileTool;
use NoahVet\Reef\Domain\Tool\FileToolInterface;
use PHPUnit\Framework\TestCase;

final class FileToolTest extends TestCase
{
    private FileToolInterface $subject;

    protected function setUp(): void
    {
        $this->subject = new FileTool();
    }

    public function testForceFilePutContents(): void
    {
        $filePath = __DIR__.'/../../../../var/test/testForceFilePutContents.txt';
        $this->subject::forceFilePutContents($filePath, 'Hello');
        self::assertEquals(
            'Hello',
            \file_get_contents($filePath),
        );
        \unlink($filePath);
    }

    public function testForceRemoveDirectory(): void
    {
        $directoryPath = __DIR__.'/../../../../var/test/testForceRemoveDirectory';
        $filePath = $directoryPath.'/testForceRemoveDirectoryChild/will-be-remove.txt';
        $this->subject::forceFilePutContents($filePath, '');
        $this->subject::forceRemoveDirectory($directoryPath);

        self::assertDirectoryDoesNotExist($directoryPath);
    }
}
