<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\Tool;

use NoahVet\Reef\Domain\Tool\ArrayTool;
use NoahVet\Reef\Domain\Tool\ArrayToolInterface;
use PHPUnit\Framework\TestCase;

final class ArrayToolTest extends TestCase
{
    private ArrayToolInterface $subject;

    protected function setUp(): void
    {
        $this->subject = new ArrayTool();
    }

    public function testRemoveDeepDuplicateValues(): void
    {
        $before = [
            0 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
            1 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
            2 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
        ];
        $expected = [
            0 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
        ];

        self::assertEquals(
            $expected,
            $this->subject::removeDeepDuplicateValues($before, 'id'),
        );
    }

    public function testRemoveDuplicateValues(): void
    {
        $before = [
            0 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
            1 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
            2 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
        ];
        $expected = [
            0 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
        ];
        /** @var \Traversable $result */
        $result = $this->subject::removeDuplicates($before, 'id');

        self::assertEquals(
            $expected,
            \iterator_to_array($result),
        );
    }
}
