<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\DependencyInjection;

use NoahVet\Reef\DependencyInjection\Configuration;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;
use Symfony\Component\Config\Definition\Processor;

class ConfigurationTest extends TestCase
{
    public function testAllConfigured(): void
    {
        $configuration = new Configuration();
        $processor = new Processor();

        $config = $processor->processConfiguration(
            $configuration,
            [[
                'app_name' => 'bsm',
                'url' => 'https://staging.vetinweb.com',
                'oauth_base_url' => 'https://auth.vetinweb.com',
                'client_id' => 'client_id',
                'client_secret' => 'client_secret',
                'service_token' => 'service_token',
                'cache_service' => 'cache.app',
            ]],
        );

        $this->assertSame([
            'app_name' => 'bsm',
            'url' => 'https://staging.vetinweb.com',
            'oauth_base_url' => 'https://auth.vetinweb.com',
            'client_id' => 'client_id',
            'client_secret' => 'client_secret',
            'service_token' => 'service_token',
            'cache_service' => 'cache.app',
            'log_url' => 'syslog://telegraf:6514',
            'rabbitmq_url' => 'amqp://rabbitmq/reef',
        ], $config);
    }

    public function testMissingUrl(): void
    {
        $configuration = new Configuration();
        $processor = new Processor();

        $this->expectException(InvalidConfigurationException::class);
        $this->expectExceptionMessage('The child config "url" under "reef" must be configured.');

        $processor->processConfiguration(
            $configuration,
            [[
                'app_name' => 'bsm',
                'client_id' => 'client_id',
                'client_secret' => 'client_secret',
            ]],
        );
    }

    public function testMissingClientId(): void
    {
        $configuration = new Configuration();
        $processor = new Processor();

        $this->expectException(InvalidConfigurationException::class);
        $this->expectExceptionMessage('The child config "client_id" under "reef" must be configured.');

        $processor->processConfiguration(
            $configuration,
            [[
                'app_name' => 'bsm',
                'url' => 'https://staging.vetinweb.com',
                'client_secret' => 'client_secret',
            ]],
        );
    }

    public function testMissingClientSecret(): void
    {
        $configuration = new Configuration();
        $processor = new Processor();

        $this->expectException(InvalidConfigurationException::class);
        $this->expectExceptionMessage('The child config "client_secret" under "reef" must be configured.');

        $processor->processConfiguration(
            $configuration,
            [[
                'app_name' => 'bsm',
                'url' => 'https://staging.vetinweb.com',
                'client_id' => 'client_id',
            ]],
        );
    }
}
