<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Model\Factory;

use NoahVet\Reef\Business\Model\Factory\TeamMemberFactory;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse200Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse200ItemUser;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse200ItemVeterinaryEstablishment;
use PHPUnit\Framework\TestCase;

class TeamMemberFactoryTest extends TestCase
{
    public function testCreate(): void
    {
        $teamMember = new V1VeterinaryEstablishmentUsersGetResponse200Item();
        $teamMemberEst = new V1VeterinaryEstablishmentUsersGetResponse200ItemVeterinaryEstablishment();
        $teamMemberEst->setId('phpunit-establishment-id');
        $teamMember->setVeterinaryEstablishment($teamMemberEst);
        $teamMemberUser = new V1VeterinaryEstablishmentUsersGetResponse200ItemUser();
        $teamMemberUser->setId('user-id');
        $teamMember->setUser($teamMemberUser);
        $teamMember->setJobTitle('jobtitle');
        $teamMember->setEntryDate(new \DateTime('-5 days'));
        $teamMember->setExitDate(new \DateTime('+5 days'));

        $factory = new TeamMemberFactory();

        $tm = $factory->create($teamMember);
        self::assertEquals('user-id', $tm->getUuid());
        self::assertEquals('jobtitle', $tm->getJobTitle());
        self::assertEquals($teamMember->getEntryDate(), $tm->getEntryDate());
        self::assertEquals($teamMember->getExitDate(), $tm->getExitDate());
    }
}
