<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Model\Factory;

use NoahVet\Reef\Business\Enumerator\ManufacturerTeamMembersEnumerator;
use NoahVet\Reef\Business\Model\Factory\ManufacturerWithTeamFactory;
use NoahVet\Reef\Business\Model\Factory\TeamMemberFactory;
use NoahVet\Reef\Jane\Model\V1ManufacturersGetResponse200Item;
use NoahVet\Reef\Jane\Model\V1ManufacturerUsersGetResponse200Item;
use NoahVet\Reef\Jane\Model\V1ManufacturerUsersGetResponse200ItemManufacturer;
use NoahVet\Reef\Jane\Model\V1ManufacturerUsersGetResponse200ItemUser;
use PHPUnit\Framework\TestCase;

class ManufacturerWithTeamFactoryTest extends TestCase
{
    protected V1ManufacturersGetResponse200Item $manufacturer;

    protected ManufacturerWithTeamFactory $factory;

    protected function setUp(): void
    {
        $this->manufacturer = new V1ManufacturersGetResponse200Item();
        $this->manufacturer->setId('phpunit-manufacturer-id');
        $this->manufacturer->setCode('phpunit-manufacturer-code');

        $teamMember = new V1ManufacturerUsersGetResponse200Item();
        $teamMemberMan = new V1ManufacturerUsersGetResponse200ItemManufacturer();
        $teamMemberMan->setId($this->manufacturer->getId());
        $teamMember->setManufacturer($teamMemberMan);
        $teamMemberUser = new V1ManufacturerUsersGetResponse200ItemUser();
        $teamMemberUser->setId('user-id');
        $teamMember->setUser($teamMemberUser);
        $teamMember->setJobTitle('jobtitle');
        $teamMember->setEntryDate(new \DateTime());
        $teamMember->setExitDate(null);

        $enumerator = $this->getMockBuilder(ManufacturerTeamMembersEnumerator::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $enumerator
            ->expects($this->once())
            ->method('getTeamMembers')
            ->with([$this->manufacturer])
            ->willReturn([
                'phpunit-manufacturer-id' => [$teamMember],
            ])
        ;

        $this->factory = new ManufacturerWithTeamFactory($enumerator, new TeamMemberFactory());
    }

    public function testCreateBatch(): void
    {
        $manWithTeams = $this->factory->createBatch([$this->manufacturer]);
        self::assertCount(1, $manWithTeams);
        $manWithTeam = $manWithTeams[0];
        self::assertEquals('phpunit-manufacturer-id', $manWithTeam->getUuid());
        self::assertEquals('phpunit-manufacturer-code', $manWithTeam->getCode());
        self::assertCount(1, $manWithTeam->getTeamMembers());
        self::assertEquals('user-id', $manWithTeam->getTeamMembers()[0]->getUuid());
    }

    public function testCreate(): void
    {
        $manWithTeam = $this->factory->create($this->manufacturer);
        self::assertEquals('phpunit-manufacturer-id', $manWithTeam->getUuid());
        self::assertEquals('phpunit-manufacturer-code', $manWithTeam->getCode());
        self::assertCount(1, $manWithTeam->getTeamMembers());
        self::assertEquals('user-id', $manWithTeam->getTeamMembers()[0]->getUuid());
    }
}
