<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Model\Factory;

use NoahVet\Reef\Business\Enumerator\VeterinaryEstablishmentTeamMembersEnumerator;
use NoahVet\Reef\Business\Model\Factory\EstablishmentWithTeamFactory;
use NoahVet\Reef\Business\Model\Factory\TeamMemberFactory;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsGetResponse200Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse200Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse200ItemUser;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse200ItemVeterinaryEstablishment;
use PHPUnit\Framework\TestCase;

class EstablishmentWithTeamFactoryTest extends TestCase
{
    public function testCreateBatch(): void
    {
        $establishment = new V1VeterinaryEstablishmentsGetResponse200Item();
        $establishment->setId('phpunit-establishment-id');
        $establishment->setPrivilegedCode('AAA111');

        $teamMember = new V1VeterinaryEstablishmentUsersGetResponse200Item();
        $teamMemberEst = new V1VeterinaryEstablishmentUsersGetResponse200ItemVeterinaryEstablishment();
        $teamMemberEst->setId($establishment->getId());
        $teamMember->setVeterinaryEstablishment($teamMemberEst);
        $teamMemberUser = new V1VeterinaryEstablishmentUsersGetResponse200ItemUser();
        $teamMemberUser->setId('user-id');
        $teamMember->setUser($teamMemberUser);
        $teamMember->setJobTitle('jobtitle');
        $teamMember->setEntryDate(null);
        $teamMember->setExitDate(null);

        $enumerator = $this->getMockBuilder(VeterinaryEstablishmentTeamMembersEnumerator::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $factory = new EstablishmentWithTeamFactory(
            $enumerator,
            new TeamMemberFactory(),
        );

        $enumerator
            ->expects($this->once())
            ->method('getTeamMembers')
            ->with([$establishment])
            ->willReturn(
                [
                    'phpunit-establishment-id' => [$teamMember],
                ],
            )
        ;

        $estWithTeams = $factory->createBatch([$establishment]);
        self::assertCount(1, $estWithTeams);
        $estWithTeam = $estWithTeams[0];
        self::assertEquals('phpunit-establishment-id', $estWithTeam->getUuid());
        self::assertCount(1, $estWithTeam->getTeamMembers());
        self::assertEquals('user-id', $estWithTeam->getTeamMembers()[0]->getUuid());
    }

    public function testCreate(): void
    {
        $establishment = new V1VeterinaryEstablishmentsGetResponse200Item();
        $establishment->setId('phpunit-establishment-id');
        $establishment->setPrivilegedCode('AAA111');

        $teamMember = new V1VeterinaryEstablishmentUsersGetResponse200Item();
        $teamMemberEst = new V1VeterinaryEstablishmentUsersGetResponse200ItemVeterinaryEstablishment();
        $teamMemberEst->setId($establishment->getId());
        $teamMember->setVeterinaryEstablishment($teamMemberEst);
        $teamMemberUser = new V1VeterinaryEstablishmentUsersGetResponse200ItemUser();
        $teamMemberUser->setId('user-id');
        $teamMember->setUser($teamMemberUser);
        $teamMember->setJobTitle('jobtitle');
        $teamMember->setEntryDate(null);
        $teamMember->setExitDate(null);

        $enumerator = $this->getMockBuilder(VeterinaryEstablishmentTeamMembersEnumerator::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $factory = new EstablishmentWithTeamFactory(
            $enumerator,
            new TeamMemberFactory(),
        );

        $enumerator
            ->expects($this->once())
            ->method('getTeamMembers')
            ->with([$establishment])
            ->willReturn(
                [
                    'phpunit-establishment-id' => [$teamMember],
                ],
            )
        ;

        $est = $factory->create($establishment);
        self::assertEquals('phpunit-establishment-id', $est->getUuid());
        self::assertCount(1, $est->getTeamMembers());
        self::assertEquals('user-id', $est->getTeamMembers()[0]->getUuid());
    }
}
