<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Enumerator;

use NoahVet\Reef\Business\Enumerator\VeterinaryEstablishmentTeamMembersEnumerator;
use NoahVet\Reef\Jane\Client;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsGetResponse200Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse200Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse200ItemUser;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse200ItemVeterinaryEstablishment;
use PHPUnit\Framework\TestCase;

class VeterinaryEstablishmentTeamMembersEnumeratorTest extends TestCase
{
    public function testGetTeamMembers(): void
    {
        $client = $this->getMockBuilder(Client::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $establishment = new V1VeterinaryEstablishmentsGetResponse200Item();
        $establishment->setId('phpunit-establishment-id');

        $teamMember = new V1VeterinaryEstablishmentUsersGetResponse200Item();
        $teamMemberEst = new V1VeterinaryEstablishmentUsersGetResponse200ItemVeterinaryEstablishment();
        $teamMemberEst->setId($establishment->getId());
        $teamMember->setVeterinaryEstablishment($teamMemberEst);
        $teamMemberUser = new V1VeterinaryEstablishmentUsersGetResponse200ItemUser();
        $teamMemberUser->setId('user-id');
        $teamMember->setUser($teamMemberUser);
        $teamMember->setJobTitle('jobtitle');
        $teamMember->setEntryDate(null);
        $teamMember->setExitDate(null);

        $now = new \DateTimeImmutable();

        $client
            ->expects(self::exactly(1))
            ->method('getAllVeterinaryEstablishmentUser')
            ->withConsecutive(
                [[
                    'page' => 0,
                    'limit' => 50,
                    'veterinaryEstablishmentId' => ['phpunit-establishment-id'],
                    'toEntryDate' => [$now->format('c'), 'null'],
                    'fromExitDate' => [$now->format('c'), 'null'],
                ]],
            )
            ->willReturnOnConsecutiveCalls(
                [$teamMember],
            )
        ;

        $enumerator = new VeterinaryEstablishmentTeamMembersEnumerator($client);

        $teamMembers = $enumerator->getTeamMembers([$establishment]);

        self::assertCount(1, $teamMembers);
        self::assertArrayHasKey('phpunit-establishment-id', $teamMembers);
        self::assertIsArray($teamMembers['phpunit-establishment-id']);
        self::assertCount(1, $teamMembers['phpunit-establishment-id']);
        self::assertSame($teamMember, $teamMembers['phpunit-establishment-id'][0]);
    }
}
