<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Enumerator;

use NoahVet\Reef\Business\Enumerator\ManufacturerTeamMembersEnumerator;
use NoahVet\Reef\Jane\Client;
use NoahVet\Reef\Jane\Model\V1ManufacturersGetResponse200Item;
use NoahVet\Reef\Jane\Model\V1ManufacturerUsersGetResponse200Item;
use NoahVet\Reef\Jane\Model\V1ManufacturerUsersGetResponse200ItemManufacturer;
use NoahVet\Reef\Jane\Model\V1ManufacturerUsersGetResponse200ItemUser;
use PHPUnit\Framework\TestCase;

class ManufacturerTeamMembersEnumeratorTest extends TestCase
{
    public function testGetTeamMembers(): void
    {
        $client = $this->getMockBuilder(Client::class)->disableOriginalConstructor()->getMock();

        $manufacturer = new V1ManufacturersGetResponse200Item();
        $manufacturer->setId('phpunit-manufacturer-id');

        $teamMember = new V1ManufacturerUsersGetResponse200Item();
        $teamMemberMan = new V1ManufacturerUsersGetResponse200ItemManufacturer();
        $teamMemberMan->setId($manufacturer->getId());
        $teamMember->setManufacturer($teamMemberMan);
        $teamMemberUser = new V1ManufacturerUsersGetResponse200ItemUser();
        $teamMemberUser->setId('user-id');
        $teamMember->setUser($teamMemberUser);
        $teamMember->setJobTitle('jobtitle');
        $teamMember->setEntryDate(new \DateTime());
        $teamMember->setExitDate(null);

        $now = new \DateTimeImmutable();

        $client
            ->expects(self::exactly(1))
            ->method('getAllManufacturerUser')
            ->withConsecutive(
                [[
                    'page' => 0,
                    'limit' => 50,
                    'manufacturerId' => ['phpunit-manufacturer-id'],
                ]],
            )
            ->willReturnOnConsecutiveCalls([$teamMember])
        ;

        $enumerator = new ManufacturerTeamMembersEnumerator($client);

        $teamMembers = $enumerator->getTeamMembers([$manufacturer]);

        self::assertCount(1, $teamMembers);
        self::assertArrayHasKey('phpunit-manufacturer-id', $teamMembers);
        self::assertIsArray($teamMembers['phpunit-manufacturer-id']);
        self::assertCount(1, $teamMembers['phpunit-manufacturer-id']);
        self::assertSame($teamMember, $teamMembers['phpunit-manufacturer-id'][0]);
    }
}
