<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Enumerator;

use NoahVet\Reef\Business\Enumerator\ManufacturerEnumerator;
use NoahVet\Reef\Jane\Client;
use NoahVet\Reef\Jane\Model\V1ManufacturersGetResponse200Item;
use PHPUnit\Framework\TestCase;
use Psr\Http\Client\NetworkExceptionInterface;

class ManufacturerEnumeratorTest extends TestCase
{
    public function testEnumerateApiDown(): void
    {
        $client = $this->getMockBuilder(Client::class)->disableOriginalConstructor()->getMock();

        $client
            ->method('getAllManufacturer')
            ->withAnyParameters()
            ->willThrowException(
                $this
                    ->getMockBuilder(NetworkExceptionInterface::class)
                    ->disableOriginalConstructor()
                    ->getMock(),
            )
        ;

        $enumerator = new ManufacturerEnumerator($client);

        self::expectException(NetworkExceptionInterface::class);

        \iterator_to_array($enumerator->enumerateAll());
    }

    public function testEnumerateAll(): void
    {
        $client = $this->getMockBuilder(Client::class)->disableOriginalConstructor()->getMock();

        $manufacturer = (new V1ManufacturersGetResponse200Item())
            ->setId('manufacturer-id')
            ->setName('Manufacturer')
            ->setCode('MANUF')
        ;

        $client
            ->expects(self::exactly(1))
            ->method('getAllManufacturer')
            ->withConsecutive([['page' => 0, 'limit' => 50]])
            ->willReturnOnConsecutiveCalls([$manufacturer])
        ;

        $enumerator = new ManufacturerEnumerator($client);

        $manufacturers = \iterator_to_array($enumerator->enumerateAll());
        self::assertCount(1, $manufacturers);
        self::assertSame($manufacturer, $manufacturers['manufacturer-id']);
    }
}
