<?php

declare(strict_types=1);

namespace NoahVet\Reef\Symfony;

use NoahVet\Reef\DependencyInjection\ReefApiClientExtension;
use NoahVet\Reef\Security\IAM\Finder\ResourceFinderInterface;
use NoahVet\Reef\Security\IAM\Generator\InternalGeneratorInterface;
use NoahVet\Reef\Security\IAM\Mapper\InternalResourceMapperInterface;
use NoahVet\Reef\Security\Policy\PolicyInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Extension\ExtensionInterface;
use Symfony\Component\HttpKernel\Bundle\Bundle;

class ReefApiClientBundle extends Bundle
{
    public function getContainerExtension(): ?ExtensionInterface
    {
        return new ReefApiClientExtension();
    }

    public function build(ContainerBuilder $container): void
    {
        $container->registerForAutoconfiguration(InternalResourceMapperInterface::class)
            ->addTag('reef.iam.mapper')
        ;
        $container->registerForAutoconfiguration(InternalGeneratorInterface::class)
            ->addTag('reef.iam.generator')
        ;
        $container->registerForAutoconfiguration(PolicyInterface::class)
            ->addTag('reef.iam.policy')
        ;
        $container->registerForAutoconfiguration(ResourceFinderInterface::class)
            ->addTag('reef.iam.finder')
        ;
        if (\interface_exists('HWI\Bundle\OAuthBundle\Security\Core\User\OAuthAwareUserProviderInterface')) {
            $reefUserProviderDefinition = new Definition('NoahVet\Reef\HWI\OAuth\ReefUserProvider');
            $container->addDefinitions([
                'NoahVet\Reef\HWI\OAuth\ReefUserProvider' => $reefUserProviderDefinition,
            ]);
        }
    }
}
