<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\Policy;

use NoahVet\Reef\Security\IAM\Model\Resource;
use NoahVet\Reef\Security\IAM\Model\ResourceGroup;

class PolicyResultGrant
{
    protected Resource|ResourceGroup $resource;

    protected string $principal;

    /**
     * @var array{"allow": string[], "deny": string[]}
     */
    protected array $permissionGrants;

    /**
     * @param array{"allow": string[], "deny": string[]} $permissionGrants
     */
    public function __construct(
        Resource|ResourceGroup $resource,
        string $principal,
        array $permissionGrants,
    ) {
        $this->resource = $resource;
        $this->principal = $principal;
        $this->permissionGrants = $permissionGrants;
    }

    public function getResource(): Resource|ResourceGroup
    {
        return $this->resource;
    }

    public function getPrincipal(): string
    {
        return $this->principal;
    }

    /**
     * @return array{"allow": string[], "deny": string[]}
     */
    public function getPermissionGrants(): array
    {
        return $this->permissionGrants;
    }
}
