<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\IAM\Model;

class ResourceGroup
{
    protected string $slug;

    protected function __construct(
        protected ResourceType $resourceType,
        protected string $groupId,
    ) {
        $this->slug = $this->resourceType->getGroupSlug().':'.$this->groupId;
    }

    public function __toString(): string
    {
        return $this->slug;
    }

    public static function fromString(ResourceType|string $resourceType, mixed $groupId): self
    {
        return new self(
            \is_string($resourceType) ? ResourceType::fromString($resourceType) : $resourceType,
            (string) $groupId,
        );
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    public function getResourceType(): ResourceType
    {
        return $this->resourceType;
    }

    public function getGroupId(): string
    {
        return $this->groupId;
    }
}
