<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\IAM\Model;

class Resource
{
    protected string $slug;

    protected function __construct(
        protected ResourceType $resourceType,
        protected string $resourceId,
    ) {
        $this->slug = $this->resourceType->getSlug().':'.$this->resourceId;
    }

    public function __toString(): string
    {
        return $this->slug;
    }

    public static function fromString(ResourceType|string $resourceType, mixed $resourceId): self
    {
        return new self(
            \is_string($resourceType) ? ResourceType::fromString($resourceType) : $resourceType,
            (string) $resourceId,
        );
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    public function getResourceType(): ResourceType
    {
        return $this->resourceType;
    }

    public function getResourceId(): string
    {
        return $this->resourceId;
    }
}
