<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Task\Executor;

use NoahVet\Reef\RabbitMQ\Task\ConsoleCommandTask;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Process\Process;

class ProcessConsoleTaskCommandExecutor extends AbstractExternalConsoleTaskCommandExecutor
{
    public function execute(ConsoleCommandTask $task, OutputInterface $output = null): int
    {
        $process = new Process($this->buildCommandLine($task), timeout: null);

        $process->run();

        return $process->getExitCode() ?? -1;
    }
}
