<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Task\Executor;

use NoahVet\Reef\RabbitMQ\Task\ConsoleCommandTask;
use Symfony\Component\Console\Output\OutputInterface;

class ExecConsoleTaskCommandExecutor extends AbstractExternalConsoleTaskCommandExecutor
{
    public function execute(ConsoleCommandTask $task, OutputInterface $output = null): int
    {
        if (null !== $output) {
            throw new \Exception('Output is not supported for ExecConsoleTaskCommandExecutor. Install symfony/process.');
        }

        $resultCode = -1;
        $output = null;
        \exec(\implode(' ', $this->buildCommandLine($task)), $output, $resultCode);

        return $resultCode;
    }
}
