<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Task\Executor;

use NoahVet\Reef\RabbitMQ\Task\ConsoleCommandTask;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\NullOutput;
use Symfony\Component\Console\Output\OutputInterface;

class DirectConsoleTaskCommandExecutor implements ConsoleCommandTaskExecutorInterface
{
    public function execute(ConsoleCommandTask $task, OutputInterface $output = null): int
    {
        $input = new ArrayInput($task->arguments);

        return $task->command->run($input, $output ?? new NullOutput());
    }
}
