<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Task\Executor;

use NoahVet\Reef\RabbitMQ\Task\ConsoleCommandTask;

class ConsoleTaskCommandExecutorFactory implements ConsoleTaskCommandExecutorFactoryInterface
{
    public function create(ConsoleCommandTask $task): ConsoleCommandTaskExecutorInterface
    {
        if (!$task->spawnNewProcess) {
            return new DirectConsoleTaskCommandExecutor();
        }

        if (\class_exists('Symfony\Component\Process\Process')) {
            return new ProcessConsoleTaskCommandExecutor();
        }

        return new ExecConsoleTaskCommandExecutor();
    }
}
