<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Task\Executor;

use NoahVet\Reef\RabbitMQ\Task\ConsoleCommandTask;
use Symfony\Component\Console\Output\OutputInterface;

abstract class AbstractExternalConsoleTaskCommandExecutor implements ConsoleCommandTaskExecutorInterface
{
    /**
     * @return list<string>
     */
    public function buildCommandLine(ConsoleCommandTask $task): array
    {
        $commandLine = [
            $_SERVER['PHP_SELF'] ?? '/usr/local/bin/php',
            (string) $task->command->getName(),
        ];

        foreach ($task->command->getDefinition()->getArguments() as $argument) {
            if (!isset($task->arguments[$argument->getName()])) {
                continue;
            }

            $commandLine[] = (string) $task->arguments[$argument->getName()];
        }

        foreach ($task->command->getDefinition()->getOptions() as $option) {
            if (!isset($task->arguments[$option->getName()])) {
                continue;
            }

            $commandLine[] = '--'.$option->getName().'='.\escapeshellarg((string) $task->arguments[$option->getName()]);
        }

        return $commandLine;
    }

    abstract public function execute(ConsoleCommandTask $task, OutputInterface $output = null): int;
}
