<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Producer;

use PhpAmqpLib\Connection\AbstractConnection;
use Symfony\Component\Serializer\SerializerInterface;

class InternalTaskProducerFactory
{
    public function __construct(
        private readonly string $reefAppName,
        private readonly SerializerInterface $serializer,
    ) {
    }

    public function create(AbstractConnection $connection): InternalTaskProducerInterface
    {
        return new InternalTaskProducer(
            $connection,
            $this->reefAppName,
            $this->serializer,
        );
    }
}
