<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Producer;

use NoahVet\Reef\RabbitMQ\InternalQueueTrait;
use NoahVet\Reef\RabbitMQ\Task\InternalTaskInterface;
use PhpAmqpLib\Channel\AMQPChannel;
use PhpAmqpLib\Connection\AbstractConnection;
use PhpAmqpLib\Message\AMQPMessage;
use Symfony\Component\Serializer\SerializerInterface;

class InternalTaskProducer implements InternalTaskProducerInterface
{
    use InternalQueueTrait;

    private AMQPChannel $channel;

    public function __construct(
        AbstractConnection $connection,
        private readonly string $reefAppName,
        private readonly SerializerInterface $serializer,
    ) {
        $this->channel = $connection->channel();
        $this->declareQueue($this->channel, $this->reefAppName);
    }

    public function publish(InternalTaskInterface $task): void
    {
        $message = new AMQPMessage(
            $this->serializer->serialize($task, 'json'),
            [
                'content_encoding' => 'application/json',
                'delivery_mode' => AMQPMessage::DELIVERY_MODE_PERSISTENT,
            ],
        );

        $this->channel->basic_publish(
            $message,
            '',
            'reef:'.$this->reefAppName,
        );
    }
}
