<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Consumer;

use PhpAmqpLib\Connection\AbstractConnection;
use Psr\Log\LoggerInterface;
use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;

class InternalTaskConsumerFactory
{
    public function __construct(
        private readonly EventDispatcherInterface $eventDispatcher,
        private readonly LoggerInterface $internalTaskConsumerLogger,
        private readonly string $reefAppName,
    ) {
    }

    public function create(AbstractConnection $connection): InternalTaskConsumerInterface
    {
        return new InternalTaskConsumer(
            $connection,
            $this->eventDispatcher,
            $this->internalTaskConsumerLogger,
            $this->reefAppName,
        );
    }
}
