<?php

declare(strict_types=1);

namespace NoahVet\Reef\Phpunit\Fixture;

use Symfony\Component\Security\Core\User\UserInterface;

class FixtureRepository
{
    /**
     * @var ReefTokenFixture[]
     */
    private array $fixtures;

    public function __construct()
    {
        $this->fixtures = [];
    }

    /**
     * @param ReefTokenFixture[] $fixtures
     */
    public function setFixtures(array $fixtures): void
    {
        $this->fixtures = $fixtures;
    }

    public function addFixture(ReefTokenFixture $fixture): self
    {
        $this->fixtures[] = $fixture;

        return $this;
    }

    public function findByOAuthToken(string $token): ?ReefTokenFixture
    {
        $fixtures = \array_values(
            \array_filter(
                $this->fixtures,
                fn (ReefTokenFixture $fixture) => $fixture->getToken() === $token,
            ),
        );

        return $fixtures[0] ?? null;
    }

    public function findByUser(UserInterface $user): ?ReefTokenFixture
    {
        $fixtures = \array_values(
            \array_filter(
                $this->fixtures,
                fn (ReefTokenFixture $fixture) => $fixture->getUser() === $user,
            ),
        );

        return $fixtures[0] ?? null;
    }
}
