<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1VeterinaryGroupsIdPatchBodyNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBody' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBody' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1VeterinaryGroupsIdPatchBody();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('entitled', $data) && null !== $data['entitled']) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        } elseif (\array_key_exists('entitled', $data) && null === $data['entitled']) {
            $object->setEntitled(null);
        }
        if (\array_key_exists('shortDescription', $data) && null !== $data['shortDescription']) {
            $object->setShortDescription($data['shortDescription']);
            unset($data['shortDescription']);
        } elseif (\array_key_exists('shortDescription', $data) && null === $data['shortDescription']) {
            $object->setShortDescription(null);
        }
        if (\array_key_exists('logo', $data) && null !== $data['logo']) {
            $object->setLogo($this->denormalizer->denormalize($data['logo'], 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyLogo', 'json', $context));
            unset($data['logo']);
        } elseif (\array_key_exists('logo', $data) && null === $data['logo']) {
            $object->setLogo(null);
        }
        if (\array_key_exists('banner', $data) && null !== $data['banner']) {
            $object->setBanner($this->denormalizer->denormalize($data['banner'], 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyBanner', 'json', $context));
            unset($data['banner']);
        } elseif (\array_key_exists('banner', $data) && null === $data['banner']) {
            $object->setBanner(null);
        }
        if (\array_key_exists('pictures', $data) && null !== $data['pictures']) {
            $values = [];
            foreach ($data['pictures'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyPicturesItem', 'json', $context);
            }
            $object->setPictures($values);
            unset($data['pictures']);
        } elseif (\array_key_exists('pictures', $data) && null === $data['pictures']) {
            $object->setPictures(null);
        }
        if (\array_key_exists('longDescription', $data) && null !== $data['longDescription']) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        } elseif (\array_key_exists('longDescription', $data) && null === $data['longDescription']) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('legalNoticeUrl', $data) && null !== $data['legalNoticeUrl']) {
            $object->setLegalNoticeUrl($data['legalNoticeUrl']);
            unset($data['legalNoticeUrl']);
        } elseif (\array_key_exists('legalNoticeUrl', $data) && null === $data['legalNoticeUrl']) {
            $object->setLegalNoticeUrl(null);
        }
        if (\array_key_exists('generalConditionUrl', $data) && null !== $data['generalConditionUrl']) {
            $object->setGeneralConditionUrl($data['generalConditionUrl']);
            unset($data['generalConditionUrl']);
        } elseif (\array_key_exists('generalConditionUrl', $data) && null === $data['generalConditionUrl']) {
            $object->setGeneralConditionUrl(null);
        }
        if (\array_key_exists('privacyPolicyUrl', $data) && null !== $data['privacyPolicyUrl']) {
            $object->setPrivacyPolicyUrl($data['privacyPolicyUrl']);
            unset($data['privacyPolicyUrl']);
        } elseif (\array_key_exists('privacyPolicyUrl', $data) && null === $data['privacyPolicyUrl']) {
            $object->setPrivacyPolicyUrl(null);
        }
        if (\array_key_exists('postalAddresses', $data) && null !== $data['postalAddresses']) {
            $values_1 = [];
            foreach ($data['postalAddresses'] as $value_1) {
                $values_1[] = $this->denormalizer->denormalize($value_1, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyPostalAddressesItem', 'json', $context);
            }
            $object->setPostalAddresses($values_1);
            unset($data['postalAddresses']);
        } elseif (\array_key_exists('postalAddresses', $data) && null === $data['postalAddresses']) {
            $object->setPostalAddresses(null);
        }
        if (\array_key_exists('groupCode', $data) && null !== $data['groupCode']) {
            $object->setGroupCode($data['groupCode']);
            unset($data['groupCode']);
        } elseif (\array_key_exists('groupCode', $data) && null === $data['groupCode']) {
            $object->setGroupCode(null);
        }
        if (\array_key_exists('metadata', $data) && null !== $data['metadata']) {
            $values_2 = [];
            foreach ($data['metadata'] as $value_2) {
                $values_2[] = $this->denormalizer->denormalize($value_2, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyMetadataItem', 'json', $context);
            }
            $object->setMetadata($values_2);
            unset($data['metadata']);
        } elseif (\array_key_exists('metadata', $data) && null === $data['metadata']) {
            $object->setMetadata(null);
        }
        if (\array_key_exists('legalStructure', $data) && null !== $data['legalStructure']) {
            $object->setLegalStructure($this->denormalizer->denormalize($data['legalStructure'], 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyLegalStructure', 'json', $context));
            unset($data['legalStructure']);
        } elseif (\array_key_exists('legalStructure', $data) && null === $data['legalStructure']) {
            $object->setLegalStructure(null);
        }
        if (\array_key_exists('mainBillingAccount', $data) && null !== $data['mainBillingAccount']) {
            $object->setMainBillingAccount($this->denormalizer->denormalize($data['mainBillingAccount'], 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyMainBillingAccount', 'json', $context));
            unset($data['mainBillingAccount']);
        } elseif (\array_key_exists('mainBillingAccount', $data) && null === $data['mainBillingAccount']) {
            $object->setMainBillingAccount(null);
        }
        foreach ($data as $key => $value_3) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_3;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('entitled') && null !== $object->getEntitled()) {
            $data['entitled'] = $object->getEntitled();
        }
        if ($object->isInitialized('shortDescription') && null !== $object->getShortDescription()) {
            $data['shortDescription'] = $object->getShortDescription();
        }
        if ($object->isInitialized('logo') && null !== $object->getLogo()) {
            $data['logo'] = $this->normalizer->normalize($object->getLogo(), 'json', $context);
        }
        if ($object->isInitialized('banner') && null !== $object->getBanner()) {
            $data['banner'] = $this->normalizer->normalize($object->getBanner(), 'json', $context);
        }
        if ($object->isInitialized('pictures') && null !== $object->getPictures()) {
            $values = [];
            foreach ($object->getPictures() as $value) {
                $values[] = $this->normalizer->normalize($value, 'json', $context);
            }
            $data['pictures'] = $values;
        }
        if ($object->isInitialized('longDescription') && null !== $object->getLongDescription()) {
            $data['longDescription'] = $object->getLongDescription();
        }
        if ($object->isInitialized('legalNoticeUrl') && null !== $object->getLegalNoticeUrl()) {
            $data['legalNoticeUrl'] = $object->getLegalNoticeUrl();
        }
        if ($object->isInitialized('generalConditionUrl') && null !== $object->getGeneralConditionUrl()) {
            $data['generalConditionUrl'] = $object->getGeneralConditionUrl();
        }
        if ($object->isInitialized('privacyPolicyUrl') && null !== $object->getPrivacyPolicyUrl()) {
            $data['privacyPolicyUrl'] = $object->getPrivacyPolicyUrl();
        }
        if ($object->isInitialized('postalAddresses') && null !== $object->getPostalAddresses()) {
            $values_1 = [];
            foreach ($object->getPostalAddresses() as $value_1) {
                $values_1[] = $this->normalizer->normalize($value_1, 'json', $context);
            }
            $data['postalAddresses'] = $values_1;
        }
        if ($object->isInitialized('groupCode') && null !== $object->getGroupCode()) {
            $data['groupCode'] = $object->getGroupCode();
        }
        if ($object->isInitialized('metadata') && null !== $object->getMetadata()) {
            $values_2 = [];
            foreach ($object->getMetadata() as $value_2) {
                $values_2[] = $this->normalizer->normalize($value_2, 'json', $context);
            }
            $data['metadata'] = $values_2;
        }
        if ($object->isInitialized('legalStructure') && null !== $object->getLegalStructure()) {
            $data['legalStructure'] = $this->normalizer->normalize($object->getLegalStructure(), 'json', $context);
        }
        if ($object->isInitialized('mainBillingAccount') && null !== $object->getMainBillingAccount()) {
            $data['mainBillingAccount'] = $this->normalizer->normalize($object->getMainBillingAccount(), 'json', $context);
        }
        foreach ($object as $key => $value_3) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_3;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBody' => false];
    }
}
