<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1VeterinaryGroupUserInvitationsPostBodyNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostBody' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostBody' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1VeterinaryGroupUserInvitationsPostBody();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('departments', $data) && null !== $data['departments']) {
            $values = [];
            foreach ($data['departments'] as $value) {
                $values[] = $value;
            }
            $object->setDepartments($values);
            unset($data['departments']);
        } elseif (\array_key_exists('departments', $data) && null === $data['departments']) {
            $object->setDepartments(null);
        }
        if (\array_key_exists('emailTemplateNumber', $data)) {
            $object->setEmailTemplateNumber($data['emailTemplateNumber']);
            unset($data['emailTemplateNumber']);
        }
        if (\array_key_exists('expirationDate', $data) && null !== $data['expirationDate']) {
            $object->setExpirationDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['expirationDate']));
            unset($data['expirationDate']);
        } elseif (\array_key_exists('expirationDate', $data) && null === $data['expirationDate']) {
            $object->setExpirationDate(null);
        }
        if (\array_key_exists('entryDate', $data)) {
            $object->setEntryDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['entryDate']));
            unset($data['entryDate']);
        }
        if (\array_key_exists('exitDate', $data) && null !== $data['exitDate']) {
            $object->setExitDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['exitDate']));
            unset($data['exitDate']);
        } elseif (\array_key_exists('exitDate', $data) && null === $data['exitDate']) {
            $object->setExitDate(null);
        }
        if (\array_key_exists('invitedUser', $data)) {
            $object->setInvitedUser($this->denormalizer->denormalize($data['invitedUser'], 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostBodyInvitedUser', 'json', $context));
            unset($data['invitedUser']);
        }
        if (\array_key_exists('jobTitle', $data)) {
            $object->setJobTitle($data['jobTitle']);
            unset($data['jobTitle']);
        }
        if (\array_key_exists('veterinaryGroup', $data)) {
            $object->setVeterinaryGroup($this->denormalizer->denormalize($data['veterinaryGroup'], 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostBodyVeterinaryGroup', 'json', $context));
            unset($data['veterinaryGroup']);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('departments') && null !== $object->getDepartments()) {
            $values = [];
            foreach ($object->getDepartments() as $value) {
                $values[] = $value;
            }
            $data['departments'] = $values;
        }
        $data['emailTemplateNumber'] = $object->getEmailTemplateNumber();
        if ($object->isInitialized('expirationDate') && null !== $object->getExpirationDate()) {
            $data['expirationDate'] = $object->getExpirationDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('entryDate') && null !== $object->getEntryDate()) {
            $data['entryDate'] = $object->getEntryDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('exitDate') && null !== $object->getExitDate()) {
            $data['exitDate'] = $object->getExitDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('invitedUser') && null !== $object->getInvitedUser()) {
            $data['invitedUser'] = $this->normalizer->normalize($object->getInvitedUser(), 'json', $context);
        }
        $data['jobTitle'] = $object->getJobTitle();
        $data['veterinaryGroup'] = $this->normalizer->normalize($object->getVeterinaryGroup(), 'json', $context);
        foreach ($object as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_1;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostBody' => false];
    }
}
