<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1VeterinaryEstablishmentsIdPatchResponse200AddressesItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItem' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItem' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('entitled', $data)) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        if (\array_key_exists('city', $data) && null !== $data['city']) {
            $object->setCity($data['city']);
            unset($data['city']);
        } elseif (\array_key_exists('city', $data) && null === $data['city']) {
            $object->setCity(null);
        }
        if (\array_key_exists('country', $data) && null !== $data['country']) {
            $object->setCountry($data['country']);
            unset($data['country']);
        } elseif (\array_key_exists('country', $data) && null === $data['country']) {
            $object->setCountry(null);
        }
        if (\array_key_exists('postalCode', $data) && null !== $data['postalCode']) {
            $object->setPostalCode($data['postalCode']);
            unset($data['postalCode']);
        } elseif (\array_key_exists('postalCode', $data) && null === $data['postalCode']) {
            $object->setPostalCode(null);
        }
        if (\array_key_exists('streetName', $data) && null !== $data['streetName']) {
            $object->setStreetName($data['streetName']);
            unset($data['streetName']);
        } elseif (\array_key_exists('streetName', $data) && null === $data['streetName']) {
            $object->setStreetName(null);
        }
        if (\array_key_exists('streetNumber', $data) && null !== $data['streetNumber']) {
            $object->setStreetNumber($data['streetNumber']);
            unset($data['streetNumber']);
        } elseif (\array_key_exists('streetNumber', $data) && null === $data['streetNumber']) {
            $object->setStreetNumber(null);
        }
        if (\array_key_exists('addressSupplement', $data) && null !== $data['addressSupplement']) {
            $object->setAddressSupplement($data['addressSupplement']);
            unset($data['addressSupplement']);
        } elseif (\array_key_exists('addressSupplement', $data) && null === $data['addressSupplement']) {
            $object->setAddressSupplement(null);
        }
        if (\array_key_exists('coordinates', $data) && null !== $data['coordinates']) {
            $object->setCoordinates($this->denormalizer->denormalize($data['coordinates'], 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItemCoordinates', 'json', $context));
            unset($data['coordinates']);
        } elseif (\array_key_exists('coordinates', $data) && null === $data['coordinates']) {
            $object->setCoordinates(null);
        }
        if (\array_key_exists('department', $data) && null !== $data['department']) {
            $object->setDepartment($data['department']);
            unset($data['department']);
        } elseif (\array_key_exists('department', $data) && null === $data['department']) {
            $object->setDepartment(null);
        }
        if (\array_key_exists('postBoxNumber', $data) && null !== $data['postBoxNumber']) {
            $object->setPostBoxNumber($data['postBoxNumber']);
            unset($data['postBoxNumber']);
        } elseif (\array_key_exists('postBoxNumber', $data) && null === $data['postBoxNumber']) {
            $object->setPostBoxNumber(null);
        }
        if (\array_key_exists('recipientIdentity', $data) && null !== $data['recipientIdentity']) {
            $object->setRecipientIdentity($data['recipientIdentity']);
            unset($data['recipientIdentity']);
        } elseif (\array_key_exists('recipientIdentity', $data) && null === $data['recipientIdentity']) {
            $object->setRecipientIdentity(null);
        }
        if (\array_key_exists('region', $data) && null !== $data['region']) {
            $object->setRegion($data['region']);
            unset($data['region']);
        } elseif (\array_key_exists('region', $data) && null === $data['region']) {
            $object->setRegion(null);
        }
        if (\array_key_exists('phone', $data) && null !== $data['phone']) {
            $object->setPhone($this->denormalizer->denormalize($data['phone'], 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItemPhone', 'json', $context));
            unset($data['phone']);
        } elseif (\array_key_exists('phone', $data) && null === $data['phone']) {
            $object->setPhone(null);
        }
        if (\array_key_exists('websiteUrl', $data) && null !== $data['websiteUrl']) {
            $object->setWebsiteUrl($data['websiteUrl']);
            unset($data['websiteUrl']);
        } elseif (\array_key_exists('websiteUrl', $data) && null === $data['websiteUrl']) {
            $object->setWebsiteUrl(null);
        }
        if (\array_key_exists('email', $data) && null !== $data['email']) {
            $object->setEmail($data['email']);
            unset($data['email']);
        } elseif (\array_key_exists('email', $data) && null === $data['email']) {
            $object->setEmail(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        $data['entitled'] = $object->getEntitled();
        $data['city'] = $object->getCity();
        $data['country'] = $object->getCountry();
        $data['postalCode'] = $object->getPostalCode();
        $data['streetName'] = $object->getStreetName();
        if ($object->isInitialized('streetNumber') && null !== $object->getStreetNumber()) {
            $data['streetNumber'] = $object->getStreetNumber();
        }
        $data['addressSupplement'] = $object->getAddressSupplement();
        $data['coordinates'] = $this->normalizer->normalize($object->getCoordinates(), 'json', $context);
        $data['department'] = $object->getDepartment();
        $data['postBoxNumber'] = $object->getPostBoxNumber();
        $data['recipientIdentity'] = $object->getRecipientIdentity();
        $data['region'] = $object->getRegion();
        $data['phone'] = $this->normalizer->normalize($object->getPhone(), 'json', $context);
        if ($object->isInitialized('websiteUrl') && null !== $object->getWebsiteUrl()) {
            $data['websiteUrl'] = $object->getWebsiteUrl();
        }
        $data['email'] = $object->getEmail();
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItem' => false];
    }
}
