<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1VeterinaryEstablishmentsGetResponse206ItemScheduleNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemSchedule' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemSchedule' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsGetResponse206ItemSchedule();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('monday', $data) && null !== $data['monday']) {
            $values = [];
            foreach ($data['monday'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleMondayItem', 'json', $context);
            }
            $object->setMonday($values);
            unset($data['monday']);
        } elseif (\array_key_exists('monday', $data) && null === $data['monday']) {
            $object->setMonday(null);
        }
        if (\array_key_exists('tuesday', $data) && null !== $data['tuesday']) {
            $values_1 = [];
            foreach ($data['tuesday'] as $value_1) {
                $values_1[] = $this->denormalizer->denormalize($value_1, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleTuesdayItem', 'json', $context);
            }
            $object->setTuesday($values_1);
            unset($data['tuesday']);
        } elseif (\array_key_exists('tuesday', $data) && null === $data['tuesday']) {
            $object->setTuesday(null);
        }
        if (\array_key_exists('wednesday', $data) && null !== $data['wednesday']) {
            $values_2 = [];
            foreach ($data['wednesday'] as $value_2) {
                $values_2[] = $this->denormalizer->denormalize($value_2, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleWednesdayItem', 'json', $context);
            }
            $object->setWednesday($values_2);
            unset($data['wednesday']);
        } elseif (\array_key_exists('wednesday', $data) && null === $data['wednesday']) {
            $object->setWednesday(null);
        }
        if (\array_key_exists('thursday', $data) && null !== $data['thursday']) {
            $values_3 = [];
            foreach ($data['thursday'] as $value_3) {
                $values_3[] = $this->denormalizer->denormalize($value_3, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleThursdayItem', 'json', $context);
            }
            $object->setThursday($values_3);
            unset($data['thursday']);
        } elseif (\array_key_exists('thursday', $data) && null === $data['thursday']) {
            $object->setThursday(null);
        }
        if (\array_key_exists('friday', $data) && null !== $data['friday']) {
            $values_4 = [];
            foreach ($data['friday'] as $value_4) {
                $values_4[] = $this->denormalizer->denormalize($value_4, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleFridayItem', 'json', $context);
            }
            $object->setFriday($values_4);
            unset($data['friday']);
        } elseif (\array_key_exists('friday', $data) && null === $data['friday']) {
            $object->setFriday(null);
        }
        if (\array_key_exists('saturday', $data) && null !== $data['saturday']) {
            $values_5 = [];
            foreach ($data['saturday'] as $value_5) {
                $values_5[] = $this->denormalizer->denormalize($value_5, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSaturdayItem', 'json', $context);
            }
            $object->setSaturday($values_5);
            unset($data['saturday']);
        } elseif (\array_key_exists('saturday', $data) && null === $data['saturday']) {
            $object->setSaturday(null);
        }
        if (\array_key_exists('sunday', $data) && null !== $data['sunday']) {
            $values_6 = [];
            foreach ($data['sunday'] as $value_6) {
                $values_6[] = $this->denormalizer->denormalize($value_6, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSundayItem', 'json', $context);
            }
            $object->setSunday($values_6);
            unset($data['sunday']);
        } elseif (\array_key_exists('sunday', $data) && null === $data['sunday']) {
            $object->setSunday(null);
        }
        foreach ($data as $key => $value_7) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_7;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('monday') && null !== $object->getMonday()) {
            $values = [];
            foreach ($object->getMonday() as $value) {
                $values[] = $this->normalizer->normalize($value, 'json', $context);
            }
            $data['monday'] = $values;
        }
        if ($object->isInitialized('tuesday') && null !== $object->getTuesday()) {
            $values_1 = [];
            foreach ($object->getTuesday() as $value_1) {
                $values_1[] = $this->normalizer->normalize($value_1, 'json', $context);
            }
            $data['tuesday'] = $values_1;
        }
        if ($object->isInitialized('wednesday') && null !== $object->getWednesday()) {
            $values_2 = [];
            foreach ($object->getWednesday() as $value_2) {
                $values_2[] = $this->normalizer->normalize($value_2, 'json', $context);
            }
            $data['wednesday'] = $values_2;
        }
        if ($object->isInitialized('thursday') && null !== $object->getThursday()) {
            $values_3 = [];
            foreach ($object->getThursday() as $value_3) {
                $values_3[] = $this->normalizer->normalize($value_3, 'json', $context);
            }
            $data['thursday'] = $values_3;
        }
        if ($object->isInitialized('friday') && null !== $object->getFriday()) {
            $values_4 = [];
            foreach ($object->getFriday() as $value_4) {
                $values_4[] = $this->normalizer->normalize($value_4, 'json', $context);
            }
            $data['friday'] = $values_4;
        }
        if ($object->isInitialized('saturday') && null !== $object->getSaturday()) {
            $values_5 = [];
            foreach ($object->getSaturday() as $value_5) {
                $values_5[] = $this->normalizer->normalize($value_5, 'json', $context);
            }
            $data['saturday'] = $values_5;
        }
        if ($object->isInitialized('sunday') && null !== $object->getSunday()) {
            $values_6 = [];
            foreach ($object->getSunday() as $value_6) {
                $values_6[] = $this->normalizer->normalize($value_6, 'json', $context);
            }
            $data['sunday'] = $values_6;
        }
        foreach ($object as $key => $value_7) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_7;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemSchedule' => false];
    }
}
