<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206Item' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206Item' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServicePeriodsGetResponse206Item();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('attributes', $data)) {
            $values = [];
            foreach ($data['attributes'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemAttributesItem', 'json', $context);
            }
            $object->setAttributes($values);
            unset($data['attributes']);
        }
        if (\array_key_exists('startDate', $data)) {
            $object->setStartDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['startDate']));
            unset($data['startDate']);
        }
        if (\array_key_exists('endDate', $data)) {
            $object->setEndDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['endDate']));
            unset($data['endDate']);
        }
        if (\array_key_exists('billingMethod', $data)) {
            $object->setBillingMethod($data['billingMethod']);
            unset($data['billingMethod']);
        }
        if (\array_key_exists('paymentStatus', $data)) {
            $object->setPaymentStatus($data['paymentStatus']);
            unset($data['paymentStatus']);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemVeterinaryEstablishment', 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        if (\array_key_exists('veterinaryServiceOption', $data)) {
            $object->setVeterinaryServiceOption($this->denormalizer->denormalize($data['veterinaryServiceOption'], 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemVeterinaryServiceOption', 'json', $context));
            unset($data['veterinaryServiceOption']);
        }
        if (\array_key_exists('veterinaryEstablishmentServiceSubscription', $data)) {
            $object->setVeterinaryEstablishmentServiceSubscription($this->denormalizer->denormalize($data['veterinaryEstablishmentServiceSubscription'], 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemVeterinaryEstablishmentServiceSubscription', 'json', $context));
            unset($data['veterinaryEstablishmentServiceSubscription']);
        }
        if (\array_key_exists('billingAccount', $data) && null !== $data['billingAccount']) {
            $object->setBillingAccount($this->denormalizer->denormalize($data['billingAccount'], 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemBillingAccount', 'json', $context));
            unset($data['billingAccount']);
        } elseif (\array_key_exists('billingAccount', $data) && null === $data['billingAccount']) {
            $object->setBillingAccount(null);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        $values = [];
        foreach ($object->getAttributes() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $data['attributes'] = $values;
        $data['startDate'] = $object->getStartDate()->format('Y-m-d\\TH:i:sP');
        $data['endDate'] = $object->getEndDate()->format('Y-m-d\\TH:i:sP');
        $data['billingMethod'] = $object->getBillingMethod();
        $data['paymentStatus'] = $object->getPaymentStatus();
        $data['veterinaryEstablishment'] = $this->normalizer->normalize($object->getVeterinaryEstablishment(), 'json', $context);
        $data['veterinaryServiceOption'] = $this->normalizer->normalize($object->getVeterinaryServiceOption(), 'json', $context);
        if ($object->isInitialized('veterinaryEstablishmentServiceSubscription') && null !== $object->getVeterinaryEstablishmentServiceSubscription()) {
            $data['veterinaryEstablishmentServiceSubscription'] = $this->normalizer->normalize($object->getVeterinaryEstablishmentServiceSubscription(), 'json', $context);
        }
        if ($object->isInitialized('billingAccount') && null !== $object->getBillingAccount()) {
            $data['billingAccount'] = $this->normalizer->normalize($object->getBillingAccount(), 'json', $context);
        }
        foreach ($object as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_1;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206Item' => false];
    }
}
