<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1VeterinaryEstablishmentServiceDeliveriesIdPatchBodyNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchBody' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchBody' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServiceDeliveriesIdPatchBody();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('code', $data) && null !== $data['code']) {
            $object->setCode($data['code']);
            unset($data['code']);
        } elseif (\array_key_exists('code', $data) && null === $data['code']) {
            $object->setCode(null);
        }
        if (\array_key_exists('completionDate', $data) && null !== $data['completionDate']) {
            $object->setCompletionDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['completionDate']));
            unset($data['completionDate']);
        } elseif (\array_key_exists('completionDate', $data) && null === $data['completionDate']) {
            $object->setCompletionDate(null);
        }
        if (\array_key_exists('ebpCode', $data) && null !== $data['ebpCode']) {
            $object->setEbpCode($data['ebpCode']);
            unset($data['ebpCode']);
        } elseif (\array_key_exists('ebpCode', $data) && null === $data['ebpCode']) {
            $object->setEbpCode(null);
        }
        if (\array_key_exists('invoiceDate', $data) && null !== $data['invoiceDate']) {
            $object->setInvoiceDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['invoiceDate']));
            unset($data['invoiceDate']);
        } elseif (\array_key_exists('invoiceDate', $data) && null === $data['invoiceDate']) {
            $object->setInvoiceDate(null);
        }
        if (\array_key_exists('longDescription', $data) && null !== $data['longDescription']) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        } elseif (\array_key_exists('longDescription', $data) && null === $data['longDescription']) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('paymentStatus', $data) && null !== $data['paymentStatus']) {
            $object->setPaymentStatus($data['paymentStatus']);
            unset($data['paymentStatus']);
        } elseif (\array_key_exists('paymentStatus', $data) && null === $data['paymentStatus']) {
            $object->setPaymentStatus(null);
        }
        if (\array_key_exists('unitPriceWithoutVat', $data) && null !== $data['unitPriceWithoutVat']) {
            $object->setUnitPriceWithoutVat($data['unitPriceWithoutVat']);
            unset($data['unitPriceWithoutVat']);
        } elseif (\array_key_exists('unitPriceWithoutVat', $data) && null === $data['unitPriceWithoutVat']) {
            $object->setUnitPriceWithoutVat(null);
        }
        if (\array_key_exists('vat', $data) && null !== $data['vat']) {
            $object->setVat($data['vat']);
            unset($data['vat']);
        } elseif (\array_key_exists('vat', $data) && null === $data['vat']) {
            $object->setVat(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('code') && null !== $object->getCode()) {
            $data['code'] = $object->getCode();
        }
        if ($object->isInitialized('completionDate') && null !== $object->getCompletionDate()) {
            $data['completionDate'] = $object->getCompletionDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('ebpCode') && null !== $object->getEbpCode()) {
            $data['ebpCode'] = $object->getEbpCode();
        }
        if ($object->isInitialized('invoiceDate') && null !== $object->getInvoiceDate()) {
            $data['invoiceDate'] = $object->getInvoiceDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('longDescription') && null !== $object->getLongDescription()) {
            $data['longDescription'] = $object->getLongDescription();
        }
        if ($object->isInitialized('paymentStatus') && null !== $object->getPaymentStatus()) {
            $data['paymentStatus'] = $object->getPaymentStatus();
        }
        if ($object->isInitialized('unitPriceWithoutVat') && null !== $object->getUnitPriceWithoutVat()) {
            $data['unitPriceWithoutVat'] = $object->getUnitPriceWithoutVat();
        }
        if ($object->isInitialized('vat') && null !== $object->getVat()) {
            $data['vat'] = $object->getVat();
        }
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchBody' => false];
    }
}
