<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1PetsGetResponse206ItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206Item' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206Item' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1PetsGetResponse206Item();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('code', $data)) {
            $object->setCode($data['code']);
            unset($data['code']);
        }
        if (\array_key_exists('isAnonymous', $data)) {
            $object->setIsAnonymous($data['isAnonymous']);
            unset($data['isAnonymous']);
        }
        if (\array_key_exists('microchip', $data) && null !== $data['microchip']) {
            $object->setMicrochip($this->denormalizer->denormalize($data['microchip'], 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206ItemMicrochip', 'json', $context));
            unset($data['microchip']);
        } elseif (\array_key_exists('microchip', $data) && null === $data['microchip']) {
            $object->setMicrochip(null);
        }
        if (\array_key_exists('name', $data) && null !== $data['name']) {
            $object->setName($data['name']);
            unset($data['name']);
        } elseif (\array_key_exists('name', $data) && null === $data['name']) {
            $object->setName(null);
        }
        if (\array_key_exists('tattoo', $data) && null !== $data['tattoo']) {
            $object->setTattoo($this->denormalizer->denormalize($data['tattoo'], 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206ItemTattoo', 'json', $context));
            unset($data['tattoo']);
        } elseif (\array_key_exists('tattoo', $data) && null === $data['tattoo']) {
            $object->setTattoo(null);
        }
        if (\array_key_exists('specie', $data)) {
            $object->setSpecie($data['specie']);
            unset($data['specie']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        $data['code'] = $object->getCode();
        $data['isAnonymous'] = $object->getIsAnonymous();
        $data['microchip'] = $this->normalizer->normalize($object->getMicrochip(), 'json', $context);
        $data['name'] = $object->getName();
        $data['tattoo'] = $this->normalizer->normalize($object->getTattoo(), 'json', $context);
        $data['specie'] = $object->getSpecie();
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206Item' => false];
    }
}
