<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemFilledMandateBillingAccountNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemFilledMandateBillingAccount' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemFilledMandateBillingAccount' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemFilledMandateBillingAccount();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('iban', $data) && null !== $data['iban']) {
            $object->setIban($data['iban']);
            unset($data['iban']);
        } elseif (\array_key_exists('iban', $data) && null === $data['iban']) {
            $object->setIban(null);
        }
        if (\array_key_exists('identityName', $data)) {
            $object->setIdentityName($data['identityName']);
            unset($data['identityName']);
        }
        if (\array_key_exists('signatoryName', $data) && null !== $data['signatoryName']) {
            $object->setSignatoryName($data['signatoryName']);
            unset($data['signatoryName']);
        } elseif (\array_key_exists('signatoryName', $data) && null === $data['signatoryName']) {
            $object->setSignatoryName(null);
        }
        if (\array_key_exists('bicSwift', $data) && null !== $data['bicSwift']) {
            $object->setBicSwift($data['bicSwift']);
            unset($data['bicSwift']);
        } elseif (\array_key_exists('bicSwift', $data) && null === $data['bicSwift']) {
            $object->setBicSwift(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('id') && null !== $object->getId()) {
            $data['id'] = $object->getId();
        }
        if ($object->isInitialized('iban') && null !== $object->getIban()) {
            $data['iban'] = $object->getIban();
        }
        if ($object->isInitialized('identityName') && null !== $object->getIdentityName()) {
            $data['identityName'] = $object->getIdentityName();
        }
        if ($object->isInitialized('signatoryName') && null !== $object->getSignatoryName()) {
            $data['signatoryName'] = $object->getSignatoryName();
        }
        if ($object->isInitialized('bicSwift') && null !== $object->getBicSwift()) {
            $data['bicSwift'] = $object->getBicSwift();
        }
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemFilledMandateBillingAccount' => false];
    }
}
