<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1LegalStructuresGetResponse200ItemRequiredMandatesItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItem' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItem' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1LegalStructuresGetResponse200ItemRequiredMandatesItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('mandate', $data)) {
            $object->setMandate($this->denormalizer->denormalize($data['mandate'], 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItemMandate', 'json', $context));
            unset($data['mandate']);
        }
        if (\array_key_exists('filledMandate', $data)) {
            $object->setFilledMandate($this->denormalizer->denormalize($data['filledMandate'], 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItemFilledMandate', 'json', $context));
            unset($data['filledMandate']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('id') && null !== $object->getId()) {
            $data['id'] = $object->getId();
        }
        if ($object->isInitialized('mandate') && null !== $object->getMandate()) {
            $data['mandate'] = $this->normalizer->normalize($object->getMandate(), 'json', $context);
        }
        if ($object->isInitialized('filledMandate') && null !== $object->getFilledMandate()) {
            $data['filledMandate'] = $this->normalizer->normalize($object->getFilledMandate(), 'json', $context);
        }
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItem' => false];
    }
}
