<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class PrincipalPrincipalGetNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalGet' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalGet' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\PrincipalPrincipalGet();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('type', $data)) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        if (\array_key_exists('email', $data) && null !== $data['email']) {
            $object->setEmail($data['email']);
            unset($data['email']);
        } elseif (\array_key_exists('email', $data) && null === $data['email']) {
            $object->setEmail(null);
        }
        if (\array_key_exists('lastname', $data) && null !== $data['lastname']) {
            $object->setLastname($data['lastname']);
            unset($data['lastname']);
        } elseif (\array_key_exists('lastname', $data) && null === $data['lastname']) {
            $object->setLastname(null);
        }
        if (\array_key_exists('firstname', $data) && null !== $data['firstname']) {
            $object->setFirstname($data['firstname']);
            unset($data['firstname']);
        } elseif (\array_key_exists('firstname', $data) && null === $data['firstname']) {
            $object->setFirstname(null);
        }
        if (\array_key_exists('status', $data)) {
            $object->setStatus($data['status']);
            unset($data['status']);
        }
        if (\array_key_exists('lastLogin', $data) && null !== $data['lastLogin']) {
            $object->setLastLogin(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['lastLogin']));
            unset($data['lastLogin']);
        } elseif (\array_key_exists('lastLogin', $data) && null === $data['lastLogin']) {
            $object->setLastLogin(null);
        }
        if (\array_key_exists('locale', $data) && null !== $data['locale']) {
            $object->setLocale($data['locale']);
            unset($data['locale']);
        } elseif (\array_key_exists('locale', $data) && null === $data['locale']) {
            $object->setLocale(null);
        }
        if (\array_key_exists('timezone', $data) && null !== $data['timezone']) {
            $object->setTimezone($data['timezone']);
            unset($data['timezone']);
        } elseif (\array_key_exists('timezone', $data) && null === $data['timezone']) {
            $object->setTimezone(null);
        }
        if (\array_key_exists('birthDate', $data) && null !== $data['birthDate']) {
            $object->setBirthDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['birthDate']));
            unset($data['birthDate']);
        } elseif (\array_key_exists('birthDate', $data) && null === $data['birthDate']) {
            $object->setBirthDate(null);
        }
        if (\array_key_exists('birthPostCode', $data) && null !== $data['birthPostCode']) {
            $object->setBirthPostCode($data['birthPostCode']);
            unset($data['birthPostCode']);
        } elseif (\array_key_exists('birthPostCode', $data) && null === $data['birthPostCode']) {
            $object->setBirthPostCode(null);
        }
        if (\array_key_exists('birthCity', $data) && null !== $data['birthCity']) {
            $object->setBirthCity($data['birthCity']);
            unset($data['birthCity']);
        } elseif (\array_key_exists('birthCity', $data) && null === $data['birthCity']) {
            $object->setBirthCity(null);
        }
        if (\array_key_exists('birthCountry', $data) && null !== $data['birthCountry']) {
            $object->setBirthCountry($data['birthCountry']);
            unset($data['birthCountry']);
        } elseif (\array_key_exists('birthCountry', $data) && null === $data['birthCountry']) {
            $object->setBirthCountry(null);
        }
        if (\array_key_exists('mainAddress', $data)) {
            $object->setMainAddress($this->denormalizer->denormalize($data['mainAddress'], 'NoahVet\\Reef\\Jane\\Model\\PostalAddress', 'json', $context));
            unset($data['mainAddress']);
        }
        if (\array_key_exists('privacyPolicyAccepted', $data) && null !== $data['privacyPolicyAccepted']) {
            $object->setPrivacyPolicyAccepted(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['privacyPolicyAccepted']));
            unset($data['privacyPolicyAccepted']);
        } elseif (\array_key_exists('privacyPolicyAccepted', $data) && null === $data['privacyPolicyAccepted']) {
            $object->setPrivacyPolicyAccepted(null);
        }
        if (\array_key_exists('phoneNumbers', $data)) {
            $values = [];
            foreach ($data['phoneNumbers'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, 'NoahVet\\Reef\\Jane\\Model\\PrincipalPhoneNumber', 'json', $context);
            }
            $object->setPhoneNumbers($values);
            unset($data['phoneNumbers']);
        }
        if (\array_key_exists('mainPhoneNumber', $data) && null !== $data['mainPhoneNumber']) {
            $object->setMainPhoneNumber($data['mainPhoneNumber']);
            unset($data['mainPhoneNumber']);
        } elseif (\array_key_exists('mainPhoneNumber', $data) && null === $data['mainPhoneNumber']) {
            $object->setMainPhoneNumber(null);
        }
        if (\array_key_exists('created', $data)) {
            $object->setCreated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['created']));
            unset($data['created']);
        }
        if (\array_key_exists('updated', $data)) {
            $object->setUpdated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updated']));
            unset($data['updated']);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('id') && null !== $object->getId()) {
            $data['id'] = $object->getId();
        }
        if ($object->isInitialized('type') && null !== $object->getType()) {
            $data['type'] = $object->getType();
        }
        if ($object->isInitialized('email') && null !== $object->getEmail()) {
            $data['email'] = $object->getEmail();
        }
        if ($object->isInitialized('lastname') && null !== $object->getLastname()) {
            $data['lastname'] = $object->getLastname();
        }
        if ($object->isInitialized('firstname') && null !== $object->getFirstname()) {
            $data['firstname'] = $object->getFirstname();
        }
        if ($object->isInitialized('status') && null !== $object->getStatus()) {
            $data['status'] = $object->getStatus();
        }
        if ($object->isInitialized('lastLogin') && null !== $object->getLastLogin()) {
            $data['lastLogin'] = $object->getLastLogin()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('locale') && null !== $object->getLocale()) {
            $data['locale'] = $object->getLocale();
        }
        if ($object->isInitialized('timezone') && null !== $object->getTimezone()) {
            $data['timezone'] = $object->getTimezone();
        }
        if ($object->isInitialized('birthDate') && null !== $object->getBirthDate()) {
            $data['birthDate'] = $object->getBirthDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('birthPostCode') && null !== $object->getBirthPostCode()) {
            $data['birthPostCode'] = $object->getBirthPostCode();
        }
        if ($object->isInitialized('birthCity') && null !== $object->getBirthCity()) {
            $data['birthCity'] = $object->getBirthCity();
        }
        if ($object->isInitialized('birthCountry') && null !== $object->getBirthCountry()) {
            $data['birthCountry'] = $object->getBirthCountry();
        }
        if ($object->isInitialized('mainAddress') && null !== $object->getMainAddress()) {
            $data['mainAddress'] = $this->normalizer->normalize($object->getMainAddress(), 'json', $context);
        }
        if ($object->isInitialized('privacyPolicyAccepted') && null !== $object->getPrivacyPolicyAccepted()) {
            $data['privacyPolicyAccepted'] = $object->getPrivacyPolicyAccepted()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('phoneNumbers') && null !== $object->getPhoneNumbers()) {
            $values = [];
            foreach ($object->getPhoneNumbers() as $value) {
                $values[] = $this->normalizer->normalize($value, 'json', $context);
            }
            $data['phoneNumbers'] = $values;
        }
        if ($object->isInitialized('mainPhoneNumber') && null !== $object->getMainPhoneNumber()) {
            $data['mainPhoneNumber'] = $object->getMainPhoneNumber();
        }
        if ($object->isInitialized('created') && null !== $object->getCreated()) {
            $data['created'] = $object->getCreated()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('updated') && null !== $object->getUpdated()) {
            $data['updated'] = $object->getUpdated()->format('Y-m-d\\TH:i:sP');
        }
        foreach ($object as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_1;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalGet' => false];
    }
}
