<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class PrincipalNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\Principal' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\Principal' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\Principal();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('type', $data)) {
            $object->setType($this->denormalizer->denormalize($data['type'], 'NoahVet\\Reef\\Jane\\Model\\PrincipalTypeEnum', 'json', $context));
            unset($data['type']);
        }
        if (\array_key_exists('email', $data) && null !== $data['email']) {
            $object->setEmail($data['email']);
            unset($data['email']);
        } elseif (\array_key_exists('email', $data) && null === $data['email']) {
            $object->setEmail(null);
        }
        if (\array_key_exists('lastname', $data) && null !== $data['lastname']) {
            $object->setLastname($data['lastname']);
            unset($data['lastname']);
        } elseif (\array_key_exists('lastname', $data) && null === $data['lastname']) {
            $object->setLastname(null);
        }
        if (\array_key_exists('firstname', $data) && null !== $data['firstname']) {
            $object->setFirstname($data['firstname']);
            unset($data['firstname']);
        } elseif (\array_key_exists('firstname', $data) && null === $data['firstname']) {
            $object->setFirstname(null);
        }
        if (\array_key_exists('status', $data)) {
            $object->setStatus($this->denormalizer->denormalize($data['status'], 'NoahVet\\Reef\\Jane\\Model\\PrincipalStatusEnum', 'json', $context));
            unset($data['status']);
        }
        if (\array_key_exists('lastLogin', $data) && null !== $data['lastLogin']) {
            $object->setLastLogin(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['lastLogin']));
            unset($data['lastLogin']);
        } elseif (\array_key_exists('lastLogin', $data) && null === $data['lastLogin']) {
            $object->setLastLogin(null);
        }
        if (\array_key_exists('locale', $data) && null !== $data['locale']) {
            $object->setLocale($data['locale']);
            unset($data['locale']);
        } elseif (\array_key_exists('locale', $data) && null === $data['locale']) {
            $object->setLocale(null);
        }
        if (\array_key_exists('timezone', $data) && null !== $data['timezone']) {
            $object->setTimezone($data['timezone']);
            unset($data['timezone']);
        } elseif (\array_key_exists('timezone', $data) && null === $data['timezone']) {
            $object->setTimezone(null);
        }
        if (\array_key_exists('birthDate', $data) && null !== $data['birthDate']) {
            $object->setBirthDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['birthDate']));
            unset($data['birthDate']);
        } elseif (\array_key_exists('birthDate', $data) && null === $data['birthDate']) {
            $object->setBirthDate(null);
        }
        if (\array_key_exists('birthPostCode', $data) && null !== $data['birthPostCode']) {
            $object->setBirthPostCode($data['birthPostCode']);
            unset($data['birthPostCode']);
        } elseif (\array_key_exists('birthPostCode', $data) && null === $data['birthPostCode']) {
            $object->setBirthPostCode(null);
        }
        if (\array_key_exists('birthCity', $data) && null !== $data['birthCity']) {
            $object->setBirthCity($data['birthCity']);
            unset($data['birthCity']);
        } elseif (\array_key_exists('birthCity', $data) && null === $data['birthCity']) {
            $object->setBirthCity(null);
        }
        if (\array_key_exists('birthCountry', $data) && null !== $data['birthCountry']) {
            $value = $data['birthCountry'];
            if (\is_array($data['birthCountry'])) {
                $value = $this->denormalizer->denormalize($data['birthCountry'], 'NoahVet\\Reef\\Jane\\Model\\CountryTypeEnum', 'json', $context);
            }
            $object->setBirthCountry($value);
            unset($data['birthCountry']);
        } elseif (\array_key_exists('birthCountry', $data) && null === $data['birthCountry']) {
            $object->setBirthCountry(null);
        }
        if (\array_key_exists('mainAddress', $data)) {
            $object->setMainAddress($this->denormalizer->denormalize($data['mainAddress'], 'NoahVet\\Reef\\Jane\\Model\\PostalAddress', 'json', $context));
            unset($data['mainAddress']);
        }
        if (\array_key_exists('privacyPolicyAccepted', $data) && null !== $data['privacyPolicyAccepted']) {
            $object->setPrivacyPolicyAccepted(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['privacyPolicyAccepted']));
            unset($data['privacyPolicyAccepted']);
        } elseif (\array_key_exists('privacyPolicyAccepted', $data) && null === $data['privacyPolicyAccepted']) {
            $object->setPrivacyPolicyAccepted(null);
        }
        if (\array_key_exists('phoneNumbers', $data)) {
            $values = [];
            foreach ($data['phoneNumbers'] as $value_1) {
                $values[] = $value_1;
            }
            $object->setPhoneNumbers($values);
            unset($data['phoneNumbers']);
        }
        if (\array_key_exists('mainPhoneNumber', $data) && null !== $data['mainPhoneNumber']) {
            $object->setMainPhoneNumber($data['mainPhoneNumber']);
            unset($data['mainPhoneNumber']);
        } elseif (\array_key_exists('mainPhoneNumber', $data) && null === $data['mainPhoneNumber']) {
            $object->setMainPhoneNumber(null);
        }
        if (\array_key_exists('invitation', $data) && null !== $data['invitation']) {
            $value_2 = $data['invitation'];
            if (\is_array($data['invitation'])) {
                $value_2 = $this->denormalizer->denormalize($data['invitation'], 'NoahVet\\Reef\\Jane\\Model\\PrincipalInvitation', 'json', $context);
            }
            $object->setInvitation($value_2);
            unset($data['invitation']);
        } elseif (\array_key_exists('invitation', $data) && null === $data['invitation']) {
            $object->setInvitation(null);
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('created', $data)) {
            $object->setCreated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['created']));
            unset($data['created']);
        }
        if (\array_key_exists('updated', $data)) {
            $object->setUpdated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updated']));
            unset($data['updated']);
        }
        if (\array_key_exists('groups', $data)) {
            $values_1 = [];
            foreach ($data['groups'] as $value_3) {
                $values_1[] = $this->denormalizer->denormalize($value_3, 'NoahVet\\Reef\\Jane\\Model\\PrincipalGroup', 'json', $context);
            }
            $object->setGroups($values_1);
            unset($data['groups']);
        }
        if (\array_key_exists('invitationsHosted', $data)) {
            $values_2 = [];
            foreach ($data['invitationsHosted'] as $value_4) {
                $values_2[] = $this->denormalizer->denormalize($value_4, 'NoahVet\\Reef\\Jane\\Model\\PrincipalInvitation', 'json', $context);
            }
            $object->setInvitationsHosted($values_2);
            unset($data['invitationsHosted']);
        }
        if (\array_key_exists('fullname', $data) && null !== $data['fullname']) {
            $object->setFullname($data['fullname']);
            unset($data['fullname']);
        } elseif (\array_key_exists('fullname', $data) && null === $data['fullname']) {
            $object->setFullname(null);
        }
        if (\array_key_exists('enabled', $data)) {
            $object->setEnabled($data['enabled']);
            unset($data['enabled']);
        }
        if (\array_key_exists('roles', $data)) {
            $values_3 = [];
            foreach ($data['roles'] as $value_5) {
                $values_3[] = $value_5;
            }
            $object->setRoles($values_3);
            unset($data['roles']);
        }
        if (\array_key_exists('salt', $data) && null !== $data['salt']) {
            $object->setSalt($data['salt']);
            unset($data['salt']);
        } elseif (\array_key_exists('salt', $data) && null === $data['salt']) {
            $object->setSalt(null);
        }
        if (\array_key_exists('username', $data)) {
            $object->setUsername($data['username']);
            unset($data['username']);
        }
        if (\array_key_exists('userIdentifier', $data)) {
            $object->setUserIdentifier($data['userIdentifier']);
            unset($data['userIdentifier']);
        }
        if (\array_key_exists('slug', $data)) {
            $object->setSlug($data['slug']);
            unset($data['slug']);
        }
        foreach ($data as $key => $value_6) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_6;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['type'] = $this->normalizer->normalize($object->getType(), 'json', $context);
        if ($object->isInitialized('email') && null !== $object->getEmail()) {
            $data['email'] = $object->getEmail();
        }
        if ($object->isInitialized('lastname') && null !== $object->getLastname()) {
            $data['lastname'] = $object->getLastname();
        }
        if ($object->isInitialized('firstname') && null !== $object->getFirstname()) {
            $data['firstname'] = $object->getFirstname();
        }
        $data['status'] = $this->normalizer->normalize($object->getStatus(), 'json', $context);
        if ($object->isInitialized('lastLogin') && null !== $object->getLastLogin()) {
            $data['lastLogin'] = $object->getLastLogin()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('locale') && null !== $object->getLocale()) {
            $data['locale'] = $object->getLocale();
        }
        if ($object->isInitialized('timezone') && null !== $object->getTimezone()) {
            $data['timezone'] = $object->getTimezone();
        }
        if ($object->isInitialized('birthDate') && null !== $object->getBirthDate()) {
            $data['birthDate'] = $object->getBirthDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('birthPostCode') && null !== $object->getBirthPostCode()) {
            $data['birthPostCode'] = $object->getBirthPostCode();
        }
        if ($object->isInitialized('birthCity') && null !== $object->getBirthCity()) {
            $data['birthCity'] = $object->getBirthCity();
        }
        if ($object->isInitialized('birthCountry') && null !== $object->getBirthCountry()) {
            $value = $object->getBirthCountry();
            if (\is_object($object->getBirthCountry())) {
                $value = $this->normalizer->normalize($object->getBirthCountry(), 'json', $context);
            }
            $data['birthCountry'] = $value;
        }
        if ($object->isInitialized('mainAddress') && null !== $object->getMainAddress()) {
            $data['mainAddress'] = $this->normalizer->normalize($object->getMainAddress(), 'json', $context);
        }
        if ($object->isInitialized('privacyPolicyAccepted') && null !== $object->getPrivacyPolicyAccepted()) {
            $data['privacyPolicyAccepted'] = $object->getPrivacyPolicyAccepted()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('phoneNumbers') && null !== $object->getPhoneNumbers()) {
            $values = [];
            foreach ($object->getPhoneNumbers() as $value_1) {
                $values[] = $value_1;
            }
            $data['phoneNumbers'] = $values;
        }
        if ($object->isInitialized('mainPhoneNumber') && null !== $object->getMainPhoneNumber()) {
            $data['mainPhoneNumber'] = $object->getMainPhoneNumber();
        }
        if ($object->isInitialized('invitation') && null !== $object->getInvitation()) {
            $value_2 = $object->getInvitation();
            if (\is_object($object->getInvitation())) {
                $value_2 = $this->normalizer->normalize($object->getInvitation(), 'json', $context);
            }
            $data['invitation'] = $value_2;
        }
        if ($object->isInitialized('id') && null !== $object->getId()) {
            $data['id'] = $object->getId();
        }
        if ($object->isInitialized('groups') && null !== $object->getGroups()) {
            $values_1 = [];
            foreach ($object->getGroups() as $value_3) {
                $values_1[] = $this->normalizer->normalize($value_3, 'json', $context);
            }
            $data['groups'] = $values_1;
        }
        foreach ($object as $key => $value_4) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_4;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\Principal' => false];
    }
}
