<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class JaneObjectNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    protected $normalizers = ['NoahVet\\Reef\\Jane\\Model\\Client' => 'NoahVet\\Reef\\Jane\\Normalizer\\ClientNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ClientGet' => 'NoahVet\\Reef\\Jane\\Normalizer\\ClientGetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\CountryTypeEnum' => 'NoahVet\\Reef\\Jane\\Normalizer\\CountryTypeEnumNormalizer', 'NoahVet\\Reef\\Jane\\Model\\GrantedPermissionShort' => 'NoahVet\\Reef\\Jane\\Normalizer\\GrantedPermissionShortNormalizer', 'NoahVet\\Reef\\Jane\\Model\\InvitationEmailStatusEnum' => 'NoahVet\\Reef\\Jane\\Normalizer\\InvitationEmailStatusEnumNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PhoneValidationMethodEnum' => 'NoahVet\\Reef\\Jane\\Normalizer\\PhoneValidationMethodEnumNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PolicyResultPolicyResultGet' => 'NoahVet\\Reef\\Jane\\Normalizer\\PolicyResultPolicyResultGetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PolicyResultPolicyResultPost' => 'NoahVet\\Reef\\Jane\\Normalizer\\PolicyResultPolicyResultPostNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PostalAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\PostalAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\Principal' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalGet' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalPrincipalGetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalPut' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalPrincipalPutNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalInvitation' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalInvitationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalPhoneNumber' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalPhoneNumberNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalStatusEnum' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalStatusEnumNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalTypeEnum' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalTypeEnumNormalizer', 'NoahVet\\Reef\\Jane\\Model\\Resource' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupResourceGroupGet' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceGroupResourceGroupGetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupResourceGroupPost' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceGroupResourceGroupPostNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupResourceGroupPut' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceGroupResourceGroupPutNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceType' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceTypeNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceTypeGetshort' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceTypeGetshortNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PermissionGrant' => 'NoahVet\\Reef\\Jane\\Normalizer\\PermissionGrantNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PermissionGrantList' => 'NoahVet\\Reef\\Jane\\Normalizer\\PermissionGrantListNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalShort' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalShortNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalGet' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalGetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalGetPhoneNumbersItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalGetPhoneNumbersItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalPut' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalPutNormalizer', 'NoahVet\\Reef\\Jane\\Model\\PrincipalPutPhoneNumbersItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\PrincipalPutPhoneNumbersItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ServicePermission' => 'NoahVet\\Reef\\Jane\\Normalizer\\ServicePermissionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ServiceResource' => 'NoahVet\\Reef\\Jane\\Normalizer\\ServiceResourceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ServiceExternalResource' => 'NoahVet\\Reef\\Jane\\Normalizer\\ServiceExternalResourceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ServiceDefinition' => 'NoahVet\\Reef\\Jane\\Normalizer\\ServiceDefinitionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupGet' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceGroupGetNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupPost' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceGroupPostNormalizer', 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupPut' => 'NoahVet\\Reef\\Jane\\Normalizer\\ResourceGroupPutNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsGetResponse200ItemFile' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsGetResponse200ItemFileNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsGetResponse200ItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsGetResponse200ItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsGetResponse206ItemFile' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsGetResponse206ItemFileNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsGetResponse206ItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsGetResponse206ItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsPostBodyFile' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsPostBodyFileNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsPostBodyLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsPostBodyLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsPostResponse201File' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsPostResponse201FileNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsPostResponse201LegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsPostResponse201LegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsIdPatchBodyFile' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsIdPatchBodyFileNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsIdPatchResponse200File' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsIdPatchResponse200FileNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsIdPatchResponse200LegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1BillingAccountsIdPatchResponse200LegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1FilledMandatesIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1FilledMandatesIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1FilledMandatesIdPatchBodyBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1FilledMandatesIdPatchBodyBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1FilledMandatesIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1FilledMandatesIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1FilledMandatesIdPatchResponse200BillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1FilledMandatesIdPatchResponse200BillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1MandatesIdGetResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1MandatesIdGetResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdYousignSignatureRequestsGetResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdYousignSignatureRequestsGetResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1InvitationsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1InvitationsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1InvitationsGetResponse200ItemInvitedUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1InvitationsGetResponse200ItemInvitedUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1InvitationsGetResponse200ItemHostUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1InvitationsGetResponse200ItemHostUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1InvitationsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1InvitationsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1InvitationsGetResponse206ItemInvitedUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1InvitationsGetResponse206ItemInvitedUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1InvitationsGetResponse206ItemHostUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1InvitationsGetResponse206ItemHostUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUserInvitationsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationsPostBodyInvitedUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUserInvitationsPostBodyInvitedUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationsPostBodyVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUserInvitationsPostBodyVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUserInvitationsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationsPostResponse201InvitedUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUserInvitationsPostResponse201InvitedUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationsPostResponse201VeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUserInvitationsPostResponse201VeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationConfirmationsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUserInvitationConfirmationsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationConfirmationsPostBodyVeterinaryEstablishmentUserInvitation' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUserInvitationConfirmationsPostBodyVeterinaryEstablishmentUserInvitationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationConfirmationsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUserInvitationConfirmationsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationConfirmationsPostResponse201VeterinaryEstablishmentUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUserInvitationConfirmationsPostResponse201VeterinaryEstablishmentUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUserInvitationsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostBodyInvitedUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUserInvitationsPostBodyInvitedUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostBodyVeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUserInvitationsPostBodyVeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUserInvitationsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostResponse201InvitedUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUserInvitationsPostResponse201InvitedUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostResponse201VeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUserInvitationsPostResponse201VeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationConfirmationsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUserInvitationConfirmationsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationConfirmationsPostBodyVeterinaryGroupUserInvitation' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUserInvitationConfirmationsPostBodyVeterinaryGroupUserInvitationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationConfirmationsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUserInvitationConfirmationsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationConfirmationsPostResponse201VeterinaryGroupUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUserInvitationConfirmationsPostResponse201VeterinaryGroupUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemHeadQuarterAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse200ItemHeadQuarterAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemHeadQuarterAddressCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse200ItemHeadQuarterAddressCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse200ItemRequiredMandatesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItemMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse200ItemRequiredMandatesItemMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItemFilledMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse200ItemRequiredMandatesItemFilledMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItemFilledMandateBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse200ItemRequiredMandatesItemFilledMandateBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206ItemHeadQuarterAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse206ItemHeadQuarterAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206ItemHeadQuarterAddressCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse206ItemHeadQuarterAddressCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206ItemRequiredMandatesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse206ItemRequiredMandatesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206ItemRequiredMandatesItemMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse206ItemRequiredMandatesItemMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206ItemRequiredMandatesItemFilledMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse206ItemRequiredMandatesItemFilledMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206ItemRequiredMandatesItemFilledMandateBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresGetResponse206ItemRequiredMandatesItemFilledMandateBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostBodyHeadQuarterAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresPostBodyHeadQuarterAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostBodyHeadQuarterAddressCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresPostBodyHeadQuarterAddressCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201HeadQuarterAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresPostResponse201HeadQuarterAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201HeadQuarterAddressCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresPostResponse201HeadQuarterAddressCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201RequiredMandatesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresPostResponse201RequiredMandatesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201RequiredMandatesItemMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresPostResponse201RequiredMandatesItemMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201RequiredMandatesItemFilledMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresPostResponse201RequiredMandatesItemFilledMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201RequiredMandatesItemFilledMandateBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresPostResponse201RequiredMandatesItemFilledMandateBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdGetResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200HeadQuarterAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdGetResponse200HeadQuarterAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200HeadQuarterAddressCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdGetResponse200HeadQuarterAddressCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200RequiredMandatesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdGetResponse200RequiredMandatesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200RequiredMandatesItemMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdGetResponse200RequiredMandatesItemMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200RequiredMandatesItemFilledMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdGetResponse200RequiredMandatesItemFilledMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200RequiredMandatesItemFilledMandateBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdGetResponse200RequiredMandatesItemFilledMandateBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchBodyHeadQuarterAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdPatchBodyHeadQuarterAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchBodyCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdPatchBodyCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200HeadQuarterAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdPatchResponse200HeadQuarterAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200HeadQuarterAddressCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdPatchResponse200HeadQuarterAddressCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200RequiredMandatesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdPatchResponse200RequiredMandatesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200RequiredMandatesItemMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdPatchResponse200RequiredMandatesItemMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200RequiredMandatesItemFilledMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdPatchResponse200RequiredMandatesItemFilledMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200RequiredMandatesItemFilledMandateBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresIdPatchResponse200RequiredMandatesItemFilledMandateBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200ItemHeadQuarterAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse200ItemHeadQuarterAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200ItemHeadQuarterAddressCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse200ItemHeadQuarterAddressCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200ItemRequiredMandatesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse200ItemRequiredMandatesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200ItemRequiredMandatesItemMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse200ItemRequiredMandatesItemMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200ItemRequiredMandatesItemFilledMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse200ItemRequiredMandatesItemFilledMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200ItemRequiredMandatesItemFilledMandateBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse200ItemRequiredMandatesItemFilledMandateBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemHeadQuarterAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse206ItemHeadQuarterAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemHeadQuarterAddressCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse206ItemHeadQuarterAddressCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemFilledMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemFilledMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemFilledMandateBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemFilledMandateBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturersGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse200ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturersGetResponse200ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse200ItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturersGetResponse200ItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse200ItemLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturersGetResponse200ItemLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse200ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturersGetResponse200ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturersGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse206ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturersGetResponse206ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse206ItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturersGetResponse206ItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse206ItemLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturersGetResponse206ItemLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse206ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturersGetResponse206ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1DocumentsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1DocumentsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1DocumentsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1DocumentsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1DocumentsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1DocumentsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1DocumentsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1DocumentsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ImagesGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ImagesGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ImagesGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ImagesGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ImagesPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ImagesPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ImagesPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ImagesPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1RequiredMandatesPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1RequiredMandatesPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1RequiredMandatesPostBodyMandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1RequiredMandatesPostBodyMandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1RequiredMandatesPostBodyLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1RequiredMandatesPostBodyLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1RequiredMandatesPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1RequiredMandatesPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1RequiredMandatesPostResponse201Mandate' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1RequiredMandatesPostResponse201MandateNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1RequiredMandatesPostResponse201LegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1RequiredMandatesPostResponse201LegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse200ItemServiceDeliveryOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse200ItemServiceDeliveryOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse200ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse200ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse206ItemServiceDeliveryOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse206ItemServiceDeliveryOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse206ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse206ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesPostBodyServiceDeliveryOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesPostBodyServiceDeliveryOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesPostBodyVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesPostBodyVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesPostResponse201ServiceDeliveryOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesPostResponse201ServiceDeliveryOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesPostResponse201VeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesPostResponse201VeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchResponse200ServiceDeliveryOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchResponse200ServiceDeliveryOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchResponse200VeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchResponse200VeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ServiceDeliveryOptionsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsGetResponse200ItemVeterinaryService' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ServiceDeliveryOptionsGetResponse200ItemVeterinaryServiceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ServiceDeliveryOptionsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsGetResponse206ItemVeterinaryService' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ServiceDeliveryOptionsGetResponse206ItemVeterinaryServiceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ServiceDeliveryOptionsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsPostBodyVeterinaryService' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ServiceDeliveryOptionsPostBodyVeterinaryServiceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ServiceDeliveryOptionsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsPostResponse201VeterinaryService' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ServiceDeliveryOptionsPostResponse201VeterinaryServiceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ServiceDeliveryOptionsIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsIdPatchBodyVeterinaryService' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ServiceDeliveryOptionsIdPatchBodyVeterinaryServiceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ServiceDeliveryOptionsIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsIdPatchResponse200VeterinaryService' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ServiceDeliveryOptionsIdPatchResponse200VeterinaryServiceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturerUsersGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturerUsersGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturerUsersGetResponse200ItemManufacturer' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturerUsersGetResponse200ItemManufacturerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturerUsersGetResponse200ItemUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturerUsersGetResponse200ItemUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturerUsersGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturerUsersGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturerUsersGetResponse206ItemManufacturer' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturerUsersGetResponse206ItemManufacturerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturerUsersGetResponse206ItemUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1ManufacturerUsersGetResponse206ItemUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersGetResponse200ItemUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersGetResponse200ItemUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersGetResponse200ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersGetResponse200ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersGetResponse206ItemUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersGetResponse206ItemUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersGetResponse206ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersGetResponse206ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersPostBodyUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersPostBodyUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersPostBodyVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersPostBodyVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersPostResponse201User' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersPostResponse201UserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersPostResponse201VeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersPostResponse201VeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersIdPatchResponse200User' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersIdPatchResponse200UserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersIdPatchResponse200VeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentUsersIdPatchResponse200VeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersGetResponse200ItemUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersGetResponse200ItemUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersGetResponse200ItemVeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersGetResponse200ItemVeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersGetResponse206ItemUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersGetResponse206ItemUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersGetResponse206ItemVeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersGetResponse206ItemVeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersPostBodyUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersPostBodyUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersPostBodyVeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersPostBodyVeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersPostResponse201User' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersPostResponse201UserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersPostResponse201VeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersPostResponse201VeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersIdPatchResponse200User' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersIdPatchResponse200UserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersIdPatchResponse200VeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupUsersIdPatchResponse200VeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemMainBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemMainBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemSchedule' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleMondayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleMondayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleMondayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleMondayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleMondayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleMondayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleTuesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleTuesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleTuesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleTuesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleTuesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleTuesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleWednesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleWednesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleWednesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleWednesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleWednesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleWednesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleThursdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleThursdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleThursdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleThursdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleThursdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleThursdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleFridayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleFridayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleFridayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleFridayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleFridayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleFridayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSaturdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSaturdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSaturdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSaturdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSaturdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSaturdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSundayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSundayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSundayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSundayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSundayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSundayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemAddressesItemCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemAddressesItemCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemAddressesItemPhone' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemAddressesItemPhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemTagsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemTagsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemMainAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemMainAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemActivitiesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse200ItemActivitiesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemMainBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemMainBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemSchedule' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleMondayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleMondayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleMondayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleMondayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleMondayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleMondayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleTuesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleTuesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleTuesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleTuesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleTuesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleTuesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleWednesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleWednesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleWednesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleWednesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleWednesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleWednesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleThursdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleThursdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleThursdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleThursdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleThursdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleThursdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleFridayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleFridayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleFridayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleFridayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleFridayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleFridayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSaturdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSaturdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSaturdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSaturdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSaturdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSaturdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSundayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSundayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSundayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSundayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSundayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSundayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemAddressesItemCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemAddressesItemCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemAddressesItemPhone' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemAddressesItemPhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemTagsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemTagsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemMainAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemMainAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemActivitiesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsGetResponse206ItemActivitiesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyMainBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyMainBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodySchedule' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleMondayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleMondayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleMondayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleMondayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleMondayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleMondayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleTuesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleTuesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleTuesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleTuesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleTuesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleTuesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleWednesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleWednesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleWednesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleWednesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleWednesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleWednesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleThursdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleThursdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleThursdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleThursdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleThursdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleThursdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleFridayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleFridayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleFridayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleFridayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleFridayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleFridayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleSaturdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleSaturdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleSaturdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleSaturdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleSaturdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleSaturdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleSundayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleSundayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleSundayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleSundayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleSundayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyScheduleSundayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyTagsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostBodyTagsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201LegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201LegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201MainBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201MainBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201Logo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201LogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201Banner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201BannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201PicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201PicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201Schedule' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleMondayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleMondayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleMondayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleMondayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleMondayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleMondayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleTuesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleTuesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleTuesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleTuesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleTuesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleTuesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleWednesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleWednesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleWednesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleWednesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleWednesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleWednesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleThursdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleThursdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleThursdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleThursdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleThursdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleThursdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleFridayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleFridayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleFridayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleFridayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleFridayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleFridayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleSaturdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleSaturdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleSaturdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleSaturdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleSaturdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleSaturdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleSundayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleSundayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleSundayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleSundayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleSundayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ScheduleSundayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201AddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201AddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201AddressesItemCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201AddressesItemCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201AddressesItemPhone' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201AddressesItemPhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201TagsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201TagsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201MainAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201MainAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ActivitiesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsPostResponse201ActivitiesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200LegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200LegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200MainBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200MainBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200Logo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200LogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200Banner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200BannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200PicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200PicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200Schedule' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleMondayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleMondayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleMondayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleMondayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleMondayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleMondayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleTuesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleTuesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleTuesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleTuesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleTuesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleTuesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleWednesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleWednesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleWednesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleWednesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleWednesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleWednesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleThursdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleThursdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleThursdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleThursdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleThursdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleThursdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleFridayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleFridayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleFridayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleFridayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleFridayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleFridayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSaturdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSaturdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSaturdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSaturdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSaturdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSaturdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSundayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSundayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSundayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSundayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSundayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSundayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200AddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200AddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200AddressesItemCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200AddressesItemCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200AddressesItemPhone' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200AddressesItemPhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200TagsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200TagsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200MainAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200MainAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ActivitiesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdGetResponse200ActivitiesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyMainBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyMainBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodySchedule' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleMondayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleMondayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleMondayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleMondayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleMondayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleMondayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleTuesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleTuesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleTuesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleTuesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleTuesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleTuesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleWednesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleWednesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleWednesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleWednesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleWednesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleWednesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleThursdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleThursdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleThursdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleThursdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleThursdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleThursdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleFridayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleFridayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleFridayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleFridayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleFridayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleFridayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSaturdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSaturdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSaturdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSaturdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSaturdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSaturdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSundayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSundayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSundayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSundayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSundayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSundayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyTagsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyTagsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyMainAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchBodyMainAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200LegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200LegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200MainBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200MainBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200Logo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200LogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200Banner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200BannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200PicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200PicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200Schedule' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleMondayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleMondayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleMondayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleMondayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleMondayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleMondayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleTuesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleTuesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleTuesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleTuesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleTuesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleTuesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleWednesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleWednesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleWednesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleWednesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleWednesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleWednesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleThursdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleThursdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleThursdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleThursdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleThursdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleThursdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleFridayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleFridayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleFridayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleFridayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleFridayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleFridayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSaturdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSaturdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSaturdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSaturdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSaturdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSaturdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSundayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSundayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSundayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSundayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSundayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSundayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItemCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItemCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItemPhone' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItemPhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200TagsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200TagsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200MainAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200MainAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ActivitiesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsIdPatchResponse200ActivitiesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemMainBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemMainBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemSchedule' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleMondayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleMondayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleMondayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleMondayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleMondayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleMondayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleTuesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleTuesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleTuesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleTuesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleTuesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleTuesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleWednesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleWednesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleWednesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleWednesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleWednesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleWednesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleThursdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleThursdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleThursdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleThursdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleThursdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleThursdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleFridayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleFridayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleFridayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleFridayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleFridayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleFridayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSaturdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSaturdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSaturdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSaturdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSaturdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSaturdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSundayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSundayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSundayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSundayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSundayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSundayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemAddressesItemCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemAddressesItemCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemAddressesItemPhone' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemAddressesItemPhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemTagsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemTagsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemMainAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemMainAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemActivitiesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse200ItemActivitiesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemMainBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemMainBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemSchedule' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleMondayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleMondayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleMondayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleMondayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleMondayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleMondayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleTuesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleTuesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleTuesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleTuesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleTuesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleTuesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleWednesdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleWednesdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleWednesdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleWednesdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleWednesdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleWednesdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleThursdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleThursdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleThursdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleThursdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleThursdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleThursdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleFridayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleFridayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleFridayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleFridayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleFridayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleFridayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSaturdayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSaturdayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSaturdayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSaturdayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSaturdayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSaturdayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSundayItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSundayItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSundayItemStart' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSundayItemStartNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSundayItemEnd' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSundayItemEndNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemAddressesItemCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemAddressesItemCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemAddressesItemPhone' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemAddressesItemPhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemTagsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemTagsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemMainAddress' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemMainAddressNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemActivitiesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentsSearchPostResponse206ItemActivitiesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostBodyVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesPostBodyVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostBodyCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesPostBodyCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostBodyPhone' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesPostBodyPhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostResponse201Coordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesPostResponse201CoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostResponse201Phone' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesPostResponse201PhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesIdPatchBodyCoordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesIdPatchBodyCoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesIdPatchBodyPhone' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesIdPatchBodyPhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesIdPatchResponse200Coordinates' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesIdPatchResponse200CoordinatesNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesIdPatchResponse200Phone' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentAddressesIdPatchResponse200PhoneNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse200ItemModeration' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesGetResponse200ItemModerationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse200ItemModerationUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesGetResponse200ItemModerationUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse200ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesGetResponse200ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse206ItemModeration' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesGetResponse206ItemModerationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse206ItemModerationUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesGetResponse206ItemModerationUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse206ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesGetResponse206ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostBodyModeration' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesPostBodyModerationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostBodyModerationUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesPostBodyModerationUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostBodyVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesPostBodyVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostResponse201Moderation' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesPostResponse201ModerationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostResponse201ModerationUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesPostResponse201ModerationUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostResponse201VeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesPostResponse201VeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200Moderation' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200ModerationNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200ModerationUser' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200ModerationUserNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200VeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200VeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesBulkPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesBulkPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesBulkPatchBodyResourcesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentCreditNotesBulkPatchBodyResourcesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersGetResponse200ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersGetResponse200ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersGetResponse200ItemVeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersGetResponse200ItemVeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersGetResponse206ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersGetResponse206ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersGetResponse206ItemVeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersGetResponse206ItemVeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersPostBodyVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersPostBodyVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersPostBodyVeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersPostBodyVeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersPostResponse201VeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersPostResponse201VeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersPostResponse201VeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersPostResponse201VeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersSearchPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersSearchPostResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostResponse200ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersSearchPostResponse200ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostResponse200ItemVeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersSearchPostResponse200ItemVeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersSearchPostResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostResponse206ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersSearchPostResponse206ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostResponse206ItemVeterinaryGroup' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentMembersSearchPostResponse206ItemVeterinaryGroupNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemAttributesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemAttributesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemVeterinaryServiceOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemVeterinaryServiceOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemVeterinaryEstablishmentServiceSubscription' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemVeterinaryEstablishmentServiceSubscriptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemAttributesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemAttributesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemVeterinaryServiceOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemVeterinaryServiceOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemVeterinaryEstablishmentServiceSubscription' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemVeterinaryEstablishmentServiceSubscriptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200ItemVeterinaryServiceOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200ItemVeterinaryServiceOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200ItemBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200ItemBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206ItemVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206ItemVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206ItemVeterinaryServiceOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206ItemVeterinaryServiceOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206ItemBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206ItemBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyAttributesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyAttributesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyVeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyVeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyVeterinaryServiceOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyVeterinaryServiceOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201VeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201VeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201VeterinaryServiceOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201VeterinaryServiceOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201BillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201BillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200VeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200VeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200VeterinaryServiceOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200VeterinaryServiceOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200VeterinaryEstablishmentServiceSubscription' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200VeterinaryEstablishmentServiceSubscriptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200BillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200BillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyAttributesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyAttributesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200VeterinaryEstablishment' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200VeterinaryEstablishmentNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200VeterinaryServiceOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200VeterinaryServiceOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200VeterinaryEstablishmentServiceSubscription' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200VeterinaryEstablishmentServiceSubscriptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200BillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200BillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentTagsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentTagsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentTagsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentTagsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentTagsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentTagsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentTagsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentTagsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentTagsIdGetResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryEstablishmentTagsIdGetResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200ItemLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse200ItemLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse200ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse200ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200ItemPostalAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse200ItemPostalAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200ItemMetadataItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse200ItemMetadataItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200ItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse200ItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206ItemLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse206ItemLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse206ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse206ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206ItemPostalAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse206ItemPostalAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206ItemMetadataItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse206ItemMetadataItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206ItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsGetResponse206ItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostBodyLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostBodyBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostBodyPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyPostalAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostBodyPostalAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyMetadataItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostBodyMetadataItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostBodyLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyMainBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostBodyMainBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyCreditorsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostBodyCreditorsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201Logo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostResponse201LogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201Banner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostResponse201BannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201PicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostResponse201PicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201PostalAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostResponse201PostalAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201MetadataItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostResponse201MetadataItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201LegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostResponse201LegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201CreditorsItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsPostResponse201CreditorsItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdGetResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200Logo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdGetResponse200LogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200Banner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdGetResponse200BannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200PicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdGetResponse200PicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200PostalAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdGetResponse200PostalAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200MetadataItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdGetResponse200MetadataItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200LegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdGetResponse200LegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchBodyLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchBodyBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchBodyPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyPostalAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchBodyPostalAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyMetadataItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchBodyMetadataItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchBodyLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyMainBillingAccount' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchBodyMainBillingAccountNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200Logo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchResponse200LogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200Banner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchResponse200BannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200PicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchResponse200PicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200PostalAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchResponse200PostalAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200MetadataItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchResponse200MetadataItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200LegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsIdPatchResponse200LegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200ItemLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse200ItemLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse200ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse200ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200ItemPostalAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse200ItemPostalAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200ItemMetadataItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse200ItemMetadataItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200ItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse200ItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206ItemLogo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse206ItemLogoNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse206ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse206ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206ItemPostalAddressesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse206ItemPostalAddressesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206ItemMetadataItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse206ItemMetadataItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206ItemLegalStructure' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryGroupsSearchPostResponse206ItemLegalStructureNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServicesGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse200ItemCreditor' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServicesGetResponse200ItemCreditorNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse200ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServicesGetResponse200ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse200ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServicesGetResponse200ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse200ItemVeterinaryServiceOptions' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServicesGetResponse200ItemVeterinaryServiceOptionsNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServicesGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse206ItemCreditor' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServicesGetResponse206ItemCreditorNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse206ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServicesGetResponse206ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse206ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServicesGetResponse206ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse206ItemVeterinaryServiceOptions' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServicesGetResponse206ItemVeterinaryServiceOptionsNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServiceOptionsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse200ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServiceOptionsGetResponse200ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse200ItemVeterinaryService' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServiceOptionsGetResponse200ItemVeterinaryServiceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse200ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServiceOptionsGetResponse200ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServiceOptionsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse206ItemPicturesItem' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServiceOptionsGetResponse206ItemPicturesItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse206ItemVeterinaryService' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServiceOptionsGetResponse206ItemVeterinaryServiceNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse206ItemBanner' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServiceOptionsGetResponse206ItemBannerNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionConfigsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServiceOptionConfigsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionConfigsGetResponse200ItemVeterinaryServiceOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServiceOptionConfigsGetResponse200ItemVeterinaryServiceOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionConfigsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServiceOptionConfigsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionConfigsGetResponse206ItemVeterinaryServiceOption' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1VeterinaryServiceOptionConfigsGetResponse206ItemVeterinaryServiceOptionNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse200ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200ItemMicrochip' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse200ItemMicrochipNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200ItemTattoo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse200ItemTattooNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206Item' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse206ItemNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206ItemMicrochip' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse206ItemMicrochipNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206ItemTattoo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsGetResponse206ItemTattooNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostBody' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostBodyNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostBodyMicrochip' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostBodyMicrochipNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostBodyTattoo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostBodyTattooNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostResponse201Normalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201Microchip' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostResponse201MicrochipNormalizer', 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201Tattoo' => 'NoahVet\\Reef\\Jane\\Normalizer\\V1PetsPostResponse201TattooNormalizer', 'NoahVet\\Reef\\Jane\\Model\\OauthV2RevokeGetResponse400' => 'NoahVet\\Reef\\Jane\\Normalizer\\OauthV2RevokeGetResponse400Normalizer', 'NoahVet\\Reef\\Jane\\Model\\UserinfoGetResponse200' => 'NoahVet\\Reef\\Jane\\Normalizer\\UserinfoGetResponse200Normalizer', 'NoahVet\\Reef\\Jane\\Model\\UserinfoGetResponse401' => 'NoahVet\\Reef\\Jane\\Normalizer\\UserinfoGetResponse401Normalizer', '\\Jane\\Component\\JsonSchemaRuntime\\Reference' => '\\NoahVet\\Reef\\Jane\\Runtime\\Normalizer\\ReferenceNormalizer'];

    protected $normalizersCache = [];

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return \array_key_exists($type, $this->normalizers);
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && \array_key_exists($data::class, $this->normalizers);
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $normalizerClass = $this->normalizers[$object::class];
        $normalizer = $this->getNormalizer($normalizerClass);

        return $normalizer->normalize($object, $format, $context);
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        $denormalizerClass = $this->normalizers[$class];
        $denormalizer = $this->getNormalizer($denormalizerClass);

        return $denormalizer->denormalize($data, $class, $format, $context);
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\Client' => false, 'NoahVet\\Reef\\Jane\\Model\\ClientGet' => false, 'NoahVet\\Reef\\Jane\\Model\\CountryTypeEnum' => false, 'NoahVet\\Reef\\Jane\\Model\\GrantedPermissionShort' => false, 'NoahVet\\Reef\\Jane\\Model\\InvitationEmailStatusEnum' => false, 'NoahVet\\Reef\\Jane\\Model\\PhoneValidationMethodEnum' => false, 'NoahVet\\Reef\\Jane\\Model\\PolicyResultPolicyResultGet' => false, 'NoahVet\\Reef\\Jane\\Model\\PolicyResultPolicyResultPost' => false, 'NoahVet\\Reef\\Jane\\Model\\PostalAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\Principal' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalGet' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalPrincipalPut' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalInvitation' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalPhoneNumber' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalStatusEnum' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalTypeEnum' => false, 'NoahVet\\Reef\\Jane\\Model\\Resource' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupResourceGroupGet' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupResourceGroupPost' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupResourceGroupPut' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceType' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceTypeGetshort' => false, 'NoahVet\\Reef\\Jane\\Model\\PermissionGrant' => false, 'NoahVet\\Reef\\Jane\\Model\\PermissionGrantList' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalShort' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalGet' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalGetPhoneNumbersItem' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalPut' => false, 'NoahVet\\Reef\\Jane\\Model\\PrincipalPutPhoneNumbersItem' => false, 'NoahVet\\Reef\\Jane\\Model\\ServicePermission' => false, 'NoahVet\\Reef\\Jane\\Model\\ServiceResource' => false, 'NoahVet\\Reef\\Jane\\Model\\ServiceExternalResource' => false, 'NoahVet\\Reef\\Jane\\Model\\ServiceDefinition' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupGet' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupPost' => false, 'NoahVet\\Reef\\Jane\\Model\\ResourceGroupPut' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsGetResponse200ItemFile' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsGetResponse200ItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsGetResponse206ItemFile' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsGetResponse206ItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsPostBodyFile' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsPostBodyLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsPostResponse201File' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsPostResponse201LegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsIdPatchBodyFile' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsIdPatchResponse200File' => false, 'NoahVet\\Reef\\Jane\\Model\\V1BillingAccountsIdPatchResponse200LegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1FilledMandatesIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1FilledMandatesIdPatchBodyBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1FilledMandatesIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1FilledMandatesIdPatchResponse200BillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1MandatesIdGetResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdYousignSignatureRequestsGetResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1InvitationsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1InvitationsGetResponse200ItemInvitedUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1InvitationsGetResponse200ItemHostUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1InvitationsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1InvitationsGetResponse206ItemInvitedUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1InvitationsGetResponse206ItemHostUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationsPostBodyInvitedUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationsPostBodyVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationsPostResponse201InvitedUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationsPostResponse201VeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationConfirmationsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationConfirmationsPostBodyVeterinaryEstablishmentUserInvitation' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationConfirmationsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUserInvitationConfirmationsPostResponse201VeterinaryEstablishmentUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostBodyInvitedUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostBodyVeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostResponse201InvitedUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationsPostResponse201VeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationConfirmationsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationConfirmationsPostBodyVeterinaryGroupUserInvitation' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationConfirmationsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUserInvitationConfirmationsPostResponse201VeterinaryGroupUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemHeadQuarterAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemHeadQuarterAddressCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItemMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItemFilledMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse200ItemRequiredMandatesItemFilledMandateBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206ItemHeadQuarterAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206ItemHeadQuarterAddressCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206ItemRequiredMandatesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206ItemRequiredMandatesItemMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206ItemRequiredMandatesItemFilledMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresGetResponse206ItemRequiredMandatesItemFilledMandateBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostBodyHeadQuarterAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostBodyHeadQuarterAddressCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201HeadQuarterAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201HeadQuarterAddressCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201RequiredMandatesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201RequiredMandatesItemMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201RequiredMandatesItemFilledMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresPostResponse201RequiredMandatesItemFilledMandateBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200HeadQuarterAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200HeadQuarterAddressCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200RequiredMandatesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200RequiredMandatesItemMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200RequiredMandatesItemFilledMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdGetResponse200RequiredMandatesItemFilledMandateBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchBodyHeadQuarterAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchBodyCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200HeadQuarterAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200HeadQuarterAddressCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200RequiredMandatesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200RequiredMandatesItemMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200RequiredMandatesItemFilledMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresIdPatchResponse200RequiredMandatesItemFilledMandateBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200ItemHeadQuarterAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200ItemHeadQuarterAddressCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200ItemRequiredMandatesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200ItemRequiredMandatesItemMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200ItemRequiredMandatesItemFilledMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse200ItemRequiredMandatesItemFilledMandateBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemHeadQuarterAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemHeadQuarterAddressCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemFilledMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1LegalStructuresSearchPostResponse206ItemRequiredMandatesItemFilledMandateBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse200ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse200ItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse200ItemLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse200ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse206ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse206ItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse206ItemLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturersGetResponse206ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1DocumentsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1DocumentsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1DocumentsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1DocumentsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ImagesGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ImagesGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ImagesPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ImagesPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1RequiredMandatesPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1RequiredMandatesPostBodyMandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1RequiredMandatesPostBodyLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1RequiredMandatesPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1RequiredMandatesPostResponse201Mandate' => false, 'NoahVet\\Reef\\Jane\\Model\\V1RequiredMandatesPostResponse201LegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse200ItemServiceDeliveryOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse200ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse206ItemServiceDeliveryOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesGetResponse206ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesPostBodyServiceDeliveryOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesPostBodyVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesPostResponse201ServiceDeliveryOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesPostResponse201VeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchResponse200ServiceDeliveryOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceDeliveriesIdPatchResponse200VeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsGetResponse200ItemVeterinaryService' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsGetResponse206ItemVeterinaryService' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsPostBodyVeterinaryService' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsPostResponse201VeterinaryService' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsIdPatchBodyVeterinaryService' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ServiceDeliveryOptionsIdPatchResponse200VeterinaryService' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturerUsersGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturerUsersGetResponse200ItemManufacturer' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturerUsersGetResponse200ItemUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturerUsersGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturerUsersGetResponse206ItemManufacturer' => false, 'NoahVet\\Reef\\Jane\\Model\\V1ManufacturerUsersGetResponse206ItemUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersGetResponse200ItemUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersGetResponse200ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersGetResponse206ItemUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersGetResponse206ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersPostBodyUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersPostBodyVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersPostResponse201User' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersPostResponse201VeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersIdPatchResponse200User' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentUsersIdPatchResponse200VeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersGetResponse200ItemUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersGetResponse200ItemVeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersGetResponse206ItemUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersGetResponse206ItemVeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersPostBodyUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersPostBodyVeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersPostResponse201User' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersPostResponse201VeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersIdPatchResponse200User' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupUsersIdPatchResponse200VeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemMainBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemSchedule' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleMondayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleMondayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleMondayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleTuesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleTuesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleTuesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleWednesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleWednesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleWednesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleThursdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleThursdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleThursdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleFridayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleFridayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleFridayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSaturdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSaturdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSaturdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSundayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSundayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemScheduleSundayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemAddressesItemCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemAddressesItemPhone' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemTagsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemMainAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse200ItemActivitiesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemMainBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemSchedule' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleMondayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleMondayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleMondayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleTuesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleTuesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleTuesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleWednesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleWednesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleWednesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleThursdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleThursdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleThursdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleFridayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleFridayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleFridayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSaturdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSaturdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSaturdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSundayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSundayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemScheduleSundayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemAddressesItemCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemAddressesItemPhone' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemTagsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemMainAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsGetResponse206ItemActivitiesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyMainBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodySchedule' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleMondayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleMondayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleMondayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleTuesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleTuesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleTuesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleWednesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleWednesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleWednesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleThursdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleThursdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleThursdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleFridayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleFridayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleFridayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleSaturdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleSaturdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleSaturdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleSundayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleSundayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyScheduleSundayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostBodyTagsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201LegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201MainBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201Logo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201Banner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201PicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201Schedule' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleMondayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleMondayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleMondayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleTuesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleTuesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleTuesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleWednesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleWednesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleWednesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleThursdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleThursdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleThursdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleFridayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleFridayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleFridayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleSaturdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleSaturdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleSaturdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleSundayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleSundayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ScheduleSundayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201AddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201AddressesItemCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201AddressesItemPhone' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201TagsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201MainAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsPostResponse201ActivitiesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200LegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200MainBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200Logo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200Banner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200PicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200Schedule' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleMondayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleMondayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleMondayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleTuesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleTuesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleTuesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleWednesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleWednesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleWednesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleThursdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleThursdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleThursdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleFridayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleFridayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleFridayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSaturdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSaturdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSaturdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSundayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSundayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ScheduleSundayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200AddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200AddressesItemCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200AddressesItemPhone' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200TagsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200MainAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdGetResponse200ActivitiesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyMainBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodySchedule' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleMondayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleMondayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleMondayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleTuesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleTuesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleTuesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleWednesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleWednesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleWednesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleThursdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleThursdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleThursdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleFridayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleFridayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleFridayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSaturdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSaturdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSaturdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSundayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSundayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyScheduleSundayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyTagsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchBodyMainAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200LegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200MainBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200Logo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200Banner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200PicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200Schedule' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleMondayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleMondayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleMondayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleTuesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleTuesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleTuesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleWednesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleWednesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleWednesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleThursdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleThursdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleThursdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleFridayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleFridayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleFridayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSaturdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSaturdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSaturdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSundayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSundayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ScheduleSundayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItemCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200AddressesItemPhone' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200TagsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200MainAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsIdPatchResponse200ActivitiesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemMainBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemSchedule' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleMondayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleMondayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleMondayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleTuesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleTuesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleTuesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleWednesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleWednesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleWednesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleThursdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleThursdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleThursdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleFridayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleFridayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleFridayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSaturdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSaturdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSaturdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSundayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSundayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemScheduleSundayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemAddressesItemCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemAddressesItemPhone' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemTagsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemMainAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse200ItemActivitiesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemMainBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemSchedule' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleMondayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleMondayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleMondayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleTuesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleTuesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleTuesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleWednesdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleWednesdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleWednesdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleThursdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleThursdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleThursdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleFridayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleFridayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleFridayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSaturdayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSaturdayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSaturdayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSundayItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSundayItemStart' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemScheduleSundayItemEnd' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemAddressesItemCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemAddressesItemPhone' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemTagsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemMainAddress' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentsSearchPostResponse206ItemActivitiesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostBodyVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostBodyCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostBodyPhone' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostResponse201Coordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesPostResponse201Phone' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesIdPatchBodyCoordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesIdPatchBodyPhone' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesIdPatchResponse200Coordinates' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentAddressesIdPatchResponse200Phone' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse200ItemModeration' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse200ItemModerationUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse200ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse206ItemModeration' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse206ItemModerationUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesGetResponse206ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostBodyModeration' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostBodyModerationUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostBodyVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostResponse201Moderation' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostResponse201ModerationUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesPostResponse201VeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200Moderation' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200ModerationUser' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200VeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesBulkPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentCreditNotesBulkPatchBodyResourcesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersGetResponse200ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersGetResponse200ItemVeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersGetResponse206ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersGetResponse206ItemVeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersPostBodyVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersPostBodyVeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersPostResponse201VeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersPostResponse201VeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostResponse200ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostResponse200ItemVeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostResponse206ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentMembersSearchPostResponse206ItemVeterinaryGroup' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemAttributesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemVeterinaryServiceOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemVeterinaryEstablishmentServiceSubscription' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse200ItemBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemAttributesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemVeterinaryServiceOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemVeterinaryEstablishmentServiceSubscription' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServicePeriodsGetResponse206ItemBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200ItemVeterinaryServiceOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200ItemBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206ItemVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206ItemVeterinaryServiceOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206ItemBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyAttributesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyVeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyVeterinaryServiceOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostBodyBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201VeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201VeterinaryServiceOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201BillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200VeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200VeterinaryServiceOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200VeterinaryEstablishmentServiceSubscription' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200BillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyAttributesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200VeterinaryEstablishment' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200VeterinaryServiceOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200VeterinaryEstablishmentServiceSubscription' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200BillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentTagsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentTagsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentTagsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentTagsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryEstablishmentTagsIdGetResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200ItemLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200ItemPostalAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200ItemMetadataItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse200ItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206ItemLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206ItemPostalAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206ItemMetadataItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsGetResponse206ItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyPostalAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyMetadataItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyMainBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostBodyCreditorsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201Logo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201Banner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201PicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201PostalAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201MetadataItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201LegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsPostResponse201CreditorsItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200Logo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200Banner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200PicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200PostalAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200MetadataItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200LegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyPostalAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyMetadataItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchBodyMainBillingAccount' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200Logo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200Banner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200PicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200PostalAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200MetadataItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdPatchResponse200LegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200ItemLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200ItemPostalAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200ItemMetadataItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse200ItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206ItemLogo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206ItemPostalAddressesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206ItemMetadataItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsSearchPostResponse206ItemLegalStructure' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse200ItemCreditor' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse200ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse200ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse200ItemVeterinaryServiceOptions' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse206ItemCreditor' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse206ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse206ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServicesGetResponse206ItemVeterinaryServiceOptions' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse200ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse200ItemVeterinaryService' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse200ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse206ItemPicturesItem' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse206ItemVeterinaryService' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionsGetResponse206ItemBanner' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionConfigsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionConfigsGetResponse200ItemVeterinaryServiceOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionConfigsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryServiceOptionConfigsGetResponse206ItemVeterinaryServiceOption' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200ItemMicrochip' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse200ItemTattoo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206Item' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206ItemMicrochip' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsGetResponse206ItemTattoo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostBody' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostBodyMicrochip' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostBodyTattoo' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201Microchip' => false, 'NoahVet\\Reef\\Jane\\Model\\V1PetsPostResponse201Tattoo' => false, 'NoahVet\\Reef\\Jane\\Model\\OauthV2RevokeGetResponse400' => false, 'NoahVet\\Reef\\Jane\\Model\\UserinfoGetResponse200' => false, 'NoahVet\\Reef\\Jane\\Model\\UserinfoGetResponse401' => false, '\\Jane\\Component\\JsonSchemaRuntime\\Reference' => false];
    }

    private function getNormalizer(string $normalizerClass)
    {
        return $this->normalizersCache[$normalizerClass] ?? $this->initNormalizer($normalizerClass);
    }

    private function initNormalizer(string $normalizerClass)
    {
        $normalizer = new $normalizerClass();
        $normalizer->setNormalizer($this->normalizer);
        $normalizer->setDenormalizer($this->denormalizer);
        $this->normalizersCache[$normalizerClass] = $normalizer;

        return $normalizer;
    }
}
