<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class ClientNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\Client' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\Client' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\Client();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('name', $data)) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        if (\array_key_exists('slug', $data)) {
            $object->setSlug($data['slug']);
            unset($data['slug']);
        }
        if (\array_key_exists('randomId', $data)) {
            $object->setRandomId($data['randomId']);
            unset($data['randomId']);
        }
        if (\array_key_exists('secret', $data)) {
            $object->setSecret($data['secret']);
            unset($data['secret']);
        }
        if (\array_key_exists('redirectUris', $data)) {
            $values = [];
            foreach ($data['redirectUris'] as $value) {
                $values[] = $value;
            }
            $object->setRedirectUris($values);
            unset($data['redirectUris']);
        }
        if (\array_key_exists('allowedGrantTypes', $data)) {
            $values_1 = [];
            foreach ($data['allowedGrantTypes'] as $value_1) {
                $values_1[] = $value_1;
            }
            $object->setAllowedGrantTypes($values_1);
            unset($data['allowedGrantTypes']);
        }
        if (\array_key_exists('serviceUser', $data) && null !== $data['serviceUser']) {
            $object->setServiceUser($data['serviceUser']);
            unset($data['serviceUser']);
        } elseif (\array_key_exists('serviceUser', $data) && null === $data['serviceUser']) {
            $object->setServiceUser(null);
        }
        if (\array_key_exists('accessTokenLifetime', $data) && null !== $data['accessTokenLifetime']) {
            $object->setAccessTokenLifetime($data['accessTokenLifetime']);
            unset($data['accessTokenLifetime']);
        } elseif (\array_key_exists('accessTokenLifetime', $data) && null === $data['accessTokenLifetime']) {
            $object->setAccessTokenLifetime(null);
        }
        if (\array_key_exists('refreshTokenLifetime', $data) && null !== $data['refreshTokenLifetime']) {
            $object->setRefreshTokenLifetime($data['refreshTokenLifetime']);
            unset($data['refreshTokenLifetime']);
        } elseif (\array_key_exists('refreshTokenLifetime', $data) && null === $data['refreshTokenLifetime']) {
            $object->setRefreshTokenLifetime(null);
        }
        if (\array_key_exists('id', $data) && null !== $data['id']) {
            $object->setId($data['id']);
            unset($data['id']);
        } elseif (\array_key_exists('id', $data) && null === $data['id']) {
            $object->setId(null);
        }
        if (\array_key_exists('created', $data) && null !== $data['created']) {
            $object->setCreated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['created']));
            unset($data['created']);
        } elseif (\array_key_exists('created', $data) && null === $data['created']) {
            $object->setCreated(null);
        }
        if (\array_key_exists('updated', $data) && null !== $data['updated']) {
            $object->setUpdated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updated']));
            unset($data['updated']);
        } elseif (\array_key_exists('updated', $data) && null === $data['updated']) {
            $object->setUpdated(null);
        }
        if (\array_key_exists('clientsAccessPerms', $data)) {
            $values_2 = [];
            foreach ($data['clientsAccessPerms'] as $value_2) {
                $values_2[] = $value_2;
            }
            $object->setClientsAccessPerms($values_2);
            unset($data['clientsAccessPerms']);
        }
        if (\array_key_exists('publicId', $data)) {
            $object->setPublicId($data['publicId']);
            unset($data['publicId']);
        }
        foreach ($data as $key => $value_3) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_3;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('name') && null !== $object->getName()) {
            $data['name'] = $object->getName();
        }
        if ($object->isInitialized('slug') && null !== $object->getSlug()) {
            $data['slug'] = $object->getSlug();
        }
        if ($object->isInitialized('randomId') && null !== $object->getRandomId()) {
            $data['randomId'] = $object->getRandomId();
        }
        if ($object->isInitialized('secret') && null !== $object->getSecret()) {
            $data['secret'] = $object->getSecret();
        }
        if ($object->isInitialized('redirectUris') && null !== $object->getRedirectUris()) {
            $values = [];
            foreach ($object->getRedirectUris() as $value) {
                $values[] = $value;
            }
            $data['redirectUris'] = $values;
        }
        if ($object->isInitialized('allowedGrantTypes') && null !== $object->getAllowedGrantTypes()) {
            $values_1 = [];
            foreach ($object->getAllowedGrantTypes() as $value_1) {
                $values_1[] = $value_1;
            }
            $data['allowedGrantTypes'] = $values_1;
        }
        if ($object->isInitialized('serviceUser') && null !== $object->getServiceUser()) {
            $data['serviceUser'] = $object->getServiceUser();
        }
        if ($object->isInitialized('accessTokenLifetime') && null !== $object->getAccessTokenLifetime()) {
            $data['accessTokenLifetime'] = $object->getAccessTokenLifetime();
        }
        if ($object->isInitialized('refreshTokenLifetime') && null !== $object->getRefreshTokenLifetime()) {
            $data['refreshTokenLifetime'] = $object->getRefreshTokenLifetime();
        }
        foreach ($object as $key => $value_2) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_2;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\Client' => false];
    }
}
