<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1VeterinaryGroupsIdPatchBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $entitled;

    /**
     * @var string|null
     */
    protected $shortDescription;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryGroupsIdPatchBodyLogo|null
     */
    protected $logo;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryGroupsIdPatchBodyBanner|null
     */
    protected $banner;

    /**
     * @var V1VeterinaryGroupsIdPatchBodyPicturesItem[]|null
     */
    protected $pictures;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * @var string|null
     */
    protected $legalNoticeUrl;

    /**
     * @var string|null
     */
    protected $generalConditionUrl;

    /**
     * @var string|null
     */
    protected $privacyPolicyUrl;

    /**
     * @var V1VeterinaryGroupsIdPatchBodyPostalAddressesItem[]|null
     */
    protected $postalAddresses;

    /**
     * @var string|null
     */
    protected $groupCode;

    /**
     * @var V1VeterinaryGroupsIdPatchBodyMetadataItem[]|null
     */
    protected $metadata;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryGroupsIdPatchBodyLegalStructure|null
     */
    protected $legalStructure;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryGroupsIdPatchBodyMainBillingAccount|null
     */
    protected $mainBillingAccount;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getEntitled(): ?string
    {
        return $this->entitled;
    }

    public function setEntitled(?string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getShortDescription(): ?string
    {
        return $this->shortDescription;
    }

    public function setShortDescription(?string $shortDescription): self
    {
        $this->initialized['shortDescription'] = true;
        $this->shortDescription = $shortDescription;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getLogo(): ?V1VeterinaryGroupsIdPatchBodyLogo
    {
        return $this->logo;
    }

    /**
     * Id - Common Request Model.
     */
    public function setLogo(?V1VeterinaryGroupsIdPatchBodyLogo $logo): self
    {
        $this->initialized['logo'] = true;
        $this->logo = $logo;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getBanner(): ?V1VeterinaryGroupsIdPatchBodyBanner
    {
        return $this->banner;
    }

    /**
     * Id - Common Request Model.
     */
    public function setBanner(?V1VeterinaryGroupsIdPatchBodyBanner $banner): self
    {
        $this->initialized['banner'] = true;
        $this->banner = $banner;

        return $this;
    }

    /**
     * @return V1VeterinaryGroupsIdPatchBodyPicturesItem[]|null
     */
    public function getPictures(): ?array
    {
        return $this->pictures;
    }

    /**
     * @param V1VeterinaryGroupsIdPatchBodyPicturesItem[]|null $pictures
     */
    public function setPictures(?array $pictures): self
    {
        $this->initialized['pictures'] = true;
        $this->pictures = $pictures;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    public function getLegalNoticeUrl(): ?string
    {
        return $this->legalNoticeUrl;
    }

    public function setLegalNoticeUrl(?string $legalNoticeUrl): self
    {
        $this->initialized['legalNoticeUrl'] = true;
        $this->legalNoticeUrl = $legalNoticeUrl;

        return $this;
    }

    public function getGeneralConditionUrl(): ?string
    {
        return $this->generalConditionUrl;
    }

    public function setGeneralConditionUrl(?string $generalConditionUrl): self
    {
        $this->initialized['generalConditionUrl'] = true;
        $this->generalConditionUrl = $generalConditionUrl;

        return $this;
    }

    public function getPrivacyPolicyUrl(): ?string
    {
        return $this->privacyPolicyUrl;
    }

    public function setPrivacyPolicyUrl(?string $privacyPolicyUrl): self
    {
        $this->initialized['privacyPolicyUrl'] = true;
        $this->privacyPolicyUrl = $privacyPolicyUrl;

        return $this;
    }

    /**
     * @return V1VeterinaryGroupsIdPatchBodyPostalAddressesItem[]|null
     */
    public function getPostalAddresses(): ?array
    {
        return $this->postalAddresses;
    }

    /**
     * @param V1VeterinaryGroupsIdPatchBodyPostalAddressesItem[]|null $postalAddresses
     */
    public function setPostalAddresses(?array $postalAddresses): self
    {
        $this->initialized['postalAddresses'] = true;
        $this->postalAddresses = $postalAddresses;

        return $this;
    }

    public function getGroupCode(): ?string
    {
        return $this->groupCode;
    }

    public function setGroupCode(?string $groupCode): self
    {
        $this->initialized['groupCode'] = true;
        $this->groupCode = $groupCode;

        return $this;
    }

    /**
     * @return V1VeterinaryGroupsIdPatchBodyMetadataItem[]|null
     */
    public function getMetadata(): ?array
    {
        return $this->metadata;
    }

    /**
     * @param V1VeterinaryGroupsIdPatchBodyMetadataItem[]|null $metadata
     */
    public function setMetadata(?array $metadata): self
    {
        $this->initialized['metadata'] = true;
        $this->metadata = $metadata;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getLegalStructure(): ?V1VeterinaryGroupsIdPatchBodyLegalStructure
    {
        return $this->legalStructure;
    }

    /**
     * Id - Common Request Model.
     */
    public function setLegalStructure(?V1VeterinaryGroupsIdPatchBodyLegalStructure $legalStructure): self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getMainBillingAccount(): ?V1VeterinaryGroupsIdPatchBodyMainBillingAccount
    {
        return $this->mainBillingAccount;
    }

    /**
     * Id - Common Request Model.
     */
    public function setMainBillingAccount(?V1VeterinaryGroupsIdPatchBodyMainBillingAccount $mainBillingAccount): self
    {
        $this->initialized['mainBillingAccount'] = true;
        $this->mainBillingAccount = $mainBillingAccount;

        return $this;
    }
}
